/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.quality;

import java.util.List;
import org.talend.dataquality.common.inference.QualityAnalyzer;
import org.talend.dataquality.common.inference.ResizableList;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.common.util.LFUCache;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.SortedList;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class DataTypeQualityAnalyzer
extends QualityAnalyzer<ValueQualityStatistics, DataTypeEnum[]> {
    private static final long serialVersionUID = -5951511723860660263L;
    private final ResizableList<ValueQualityStatistics> results = new ResizableList(ValueQualityStatistics::new);
    private final ResizableList<SortedList> frequentDatePatterns = new ResizableList(SortedList::new);
    private final ResizableList<LFUCache> knownDataTypeCaches = new ResizableList(LFUCache::new);

    public DataTypeQualityAnalyzer(DataTypeEnum[] types, boolean isStoreInvalidValues) {
        this.isStoreInvalidValues = isStoreInvalidValues;
        this.setTypes(types);
    }

    public DataTypeQualityAnalyzer(DataTypeEnum ... types) {
        this.setTypes(types);
    }

    public void init() {
        this.frequentDatePatterns.clear();
        this.results.clear();
        this.knownDataTypeCaches.clear();
    }

    public boolean analyze(String ... record) {
        if (record == null) {
            record = new String[]{""};
        }
        this.results.resize(record.length);
        this.frequentDatePatterns.resize(record.length);
        this.knownDataTypeCaches.resize(record.length);
        for (int i = 0; i < record.length; ++i) {
            LFUCache knownDataTypeCache = (LFUCache)this.knownDataTypeCaches.get(i);
            String value = record[i];
            Boolean knownDataType = (Boolean)knownDataTypeCache.get((Object)value);
            ValueQualityStatistics valueQuality = (ValueQualityStatistics)this.results.get(i);
            if (knownDataType != null) {
                if (knownDataType.booleanValue()) {
                    valueQuality.incrementValid();
                    continue;
                }
                valueQuality.incrementInvalid();
                this.processInvalidValue(valueQuality, value);
                continue;
            }
            if (TypeInferenceUtils.isNullOrEmpty(value)) {
                valueQuality.incrementEmpty();
                continue;
            }
            if (DataTypeEnum.DATE == ((DataTypeEnum[])this.getTypes())[i] && SystemDateTimePatternManager.isDate(value, (SortedList)this.frequentDatePatterns.get(i))) {
                valueQuality.incrementValid();
                knownDataTypeCache.put((Object)value, (Object)Boolean.TRUE);
                continue;
            }
            if (TypeInferenceUtils.isValid(((DataTypeEnum[])this.getTypes())[i], value)) {
                valueQuality.incrementValid();
                knownDataTypeCache.put((Object)value, (Object)Boolean.TRUE);
                continue;
            }
            valueQuality.incrementInvalid();
            this.processInvalidValue(valueQuality, value);
            knownDataTypeCache.put((Object)value, (Object)Boolean.FALSE);
        }
        return true;
    }

    private void processInvalidValue(ValueQualityStatistics valueQuality, String invalidValue) {
        if (this.isStoreInvalidValues) {
            valueQuality.appendInvalidValue(invalidValue);
        }
    }

    public void end() {
    }

    public List<ValueQualityStatistics> getResult() {
        return this.results;
    }

    public void close() throws Exception {
    }
}

