/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.quality;

import java.util.ArrayList;
import java.util.List;
import org.talend.dataquality.common.inference.Analyzer;
import org.talend.dataquality.common.inference.QualityAnalyzer;
import org.talend.dataquality.common.inference.ValueQualityStatistics;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class ValueQualityAnalyzer
implements Analyzer<ValueQualityStatistics> {
    private static final long serialVersionUID = -5951511723860660263L;
    private final QualityAnalyzer<ValueQualityStatistics, DataTypeEnum[]> dataTypeQualityAnalyzer;
    private final QualityAnalyzer<ValueQualityStatistics, String[]> semanticQualityAnalyzer;

    public ValueQualityAnalyzer(QualityAnalyzer<ValueQualityStatistics, DataTypeEnum[]> dataTypeQualityAnalyzer, QualityAnalyzer<ValueQualityStatistics, String[]> semanticQualityAnalyzer, boolean isStoreInvalidValues) {
        if (dataTypeQualityAnalyzer == null) {
            throw new NullArgumentException("dataTypeQualityAnalyzer");
        }
        this.dataTypeQualityAnalyzer = dataTypeQualityAnalyzer;
        this.semanticQualityAnalyzer = semanticQualityAnalyzer;
        this.setStoreInvalidValues(isStoreInvalidValues);
    }

    public ValueQualityAnalyzer(QualityAnalyzer<ValueQualityStatistics, DataTypeEnum[]> dataTypeQualityAnalyzer, QualityAnalyzer<ValueQualityStatistics, String[]> semanticQualityAnalyzer) {
        this(dataTypeQualityAnalyzer, semanticQualityAnalyzer, true);
    }

    public void init() {
        this.dataTypeQualityAnalyzer.init();
        if (this.semanticQualityAnalyzer != null) {
            this.semanticQualityAnalyzer.init();
        }
    }

    public void setStoreInvalidValues(boolean isStoreInvalidValues) {
        this.dataTypeQualityAnalyzer.setStoreInvalidValues(isStoreInvalidValues);
        if (this.semanticQualityAnalyzer != null) {
            this.semanticQualityAnalyzer.setStoreInvalidValues(isStoreInvalidValues);
        }
    }

    public boolean analyze(String ... record) {
        boolean status = this.dataTypeQualityAnalyzer.analyze(record);
        if (status && this.semanticQualityAnalyzer != null) {
            status = this.semanticQualityAnalyzer.analyze(record);
        }
        return status;
    }

    public void end() {
    }

    public List<ValueQualityStatistics> getResult() {
        if (this.semanticQualityAnalyzer == null) {
            return this.dataTypeQualityAnalyzer.getResult();
        }
        ArrayList<ValueQualityStatistics> aggregatedResult = new ArrayList<ValueQualityStatistics>();
        List dataTypeQualityResult = this.dataTypeQualityAnalyzer.getResult();
        List semanticQualityResult = this.semanticQualityAnalyzer.getResult();
        for (int i = 0; i < dataTypeQualityResult.size(); ++i) {
            if ("UNKNOWN".equals(((String[])this.semanticQualityAnalyzer.getTypes())[i])) {
                aggregatedResult.add((ValueQualityStatistics)dataTypeQualityResult.get(i));
                continue;
            }
            aggregatedResult.add((ValueQualityStatistics)semanticQualityResult.get(i));
        }
        return aggregatedResult;
    }

    public void close() throws Exception {
        this.dataTypeQualityAnalyzer.close();
        if (this.semanticQualityAnalyzer != null) {
            this.semanticQualityAnalyzer.close();
        }
    }

    public class NullArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1174360235354917591L;

        public NullArgumentException(String argName) {
            super((argName == null ? "Argument" : argName) + " must not be null.");
        }
    }
}

