/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.talend.dataquality.common.inference.AvroAnalyzer;
import org.talend.dataquality.common.util.AvroUtils;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;
import org.talend.dataquality.statistics.type.DataTypeOccurences;
import org.talend.dataquality.statistics.type.SortedList;
import org.talend.dataquality.statistics.type.TypeInferenceUtils;

public class AvroDataTypeDiscoveryAnalyzer
implements AvroAnalyzer {
    public static final String DATA_TYPE_AGGREGATE = "talend.component.dqType";
    public static final String MATCHINGS_FIELD = "matchings";
    public static final String DATA_TYPE_FIELD = "dataType";
    public static String TOTAL_FIELD = "total";
    private static final String DATA_TYPE_DISCOVERY_VALUE_LEVEL_SCHEMA_JSON = "{\"type\": \"record\",\"name\": \"discovery_metadata\", \"namespace\": \"org.talend.dataquality\",\"fields\":[{ \"type\":\"string\", \"name\":\"dataType\"}]}";
    private static final List<LogicalType> DATE_RELATED_LOGICAL_TYPES = Arrays.asList(LogicalTypes.date(), LogicalTypes.timestampMillis(), LogicalTypes.timestampMicros());
    public static final Schema DATA_TYPE_DISCOVERY_VALUE_LEVEL_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"discovery_metadata\", \"namespace\": \"org.talend.dataquality\",\"fields\":[{ \"type\":\"string\", \"name\":\"dataType\"}]}");
    private final Map<String, SortedList> frequentDatePatterns = new HashMap<String, SortedList>();
    private final Map<String, DataTypeOccurences> dataTypeResults = new HashMap<String, DataTypeOccurences>();
    private Schema inputSemanticSchema;
    private Schema outputSemanticSchema;
    private Schema outputRecordSemanticSchema;
    static final Comparator<Map.Entry<DataTypeEnum, Long>> entryComparator = (t0, t1) -> {
        int dataTypeEnumComparaison = DataTypeEnum.dataTypeEnumComparator.compare((DataTypeEnum)((Object)((Object)t0.getKey())), (DataTypeEnum)((Object)((Object)t1.getKey())));
        return dataTypeEnumComparaison != 0 ? dataTypeEnumComparaison : ((Long)t0.getValue()).compareTo((Long)t1.getValue());
    };

    public void init() {
        this.frequentDatePatterns.clear();
        this.dataTypeResults.clear();
    }

    public void init(Schema semanticSchema) {
        this.init();
        Schema cleanSchema = AvroUtils.cleanSchema((Schema)semanticSchema, Arrays.asList(DATA_TYPE_AGGREGATE));
        this.inputSemanticSchema = AvroUtils.dereferencing((Schema)cleanSchema);
        this.outputSemanticSchema = AvroUtils.copySchema((Schema)this.inputSemanticSchema);
        this.outputRecordSemanticSchema = AvroUtils.createRecordSemanticSchema((Schema)this.inputSemanticSchema, (Schema)DATA_TYPE_DISCOVERY_VALUE_LEVEL_SCHEMA);
    }

    public boolean analyze(IndexedRecord record) {
        this.analyzeRecord(record);
        return true;
    }

    public Stream<IndexedRecord> analyze(Stream<IndexedRecord> records) {
        return ((Stream)records.sequential()).map(this::analyzeRecord);
    }

    private IndexedRecord analyzeRecord(IndexedRecord record) {
        if (record == null) {
            return null;
        }
        GenericData.Record resultRecord = new GenericData.Record(this.outputRecordSemanticSchema);
        this.analyzeRecord("", record, (GenericRecord)resultRecord, this.inputSemanticSchema);
        return resultRecord;
    }

    private void analyzeRecord(String id, IndexedRecord record, GenericRecord resultRecord, Schema semanticSchema) {
        for (Schema.Field field : record.getSchema().getFields()) {
            String itemId = AvroUtils.itemId((String)id, (String)field.name());
            Schema.Field resultField = resultRecord.getSchema().getField(field.name());
            Schema.Field semanticField = semanticSchema.getField(field.name());
            if (resultField != null) {
                if (semanticField != null) {
                    Object semRecord = this.analyzeItem(itemId, record.get(field.pos()), field.schema(), resultField.schema(), semanticField.schema());
                    resultRecord.put(field.name(), semRecord);
                    continue;
                }
                System.out.println(field.name() + " field is missing from semantic schema.");
                continue;
            }
            System.out.println(field.name() + " field is missing from result record schema.");
        }
    }

    private Object analyzeItem(String itemId, Object item, Schema itemSchema, Schema resultSchema, Schema fieldSemanticSchema) {
        switch (itemSchema.getType()) {
            case RECORD: {
                GenericData.Record resultRecord = new GenericData.Record(resultSchema);
                this.analyzeRecord(itemId, (IndexedRecord)((GenericRecord)item), (GenericRecord)resultRecord, fieldSemanticSchema);
                return resultRecord;
            }
            case ARRAY: {
                ArrayList<Object> resultArray = new ArrayList<Object>();
                for (Object obj : (List)item) {
                    resultArray.add(this.analyzeItem(itemId, obj, itemSchema.getElementType(), resultSchema.getElementType(), fieldSemanticSchema.getElementType()));
                }
                return new GenericData.Array(resultSchema, resultArray);
            }
            case MAP: {
                Map itemMap = (Map)item;
                HashMap resultMap = new HashMap();
                for (Map.Entry itemValue : itemMap.entrySet()) {
                    resultMap.put(itemValue.getKey(), this.analyzeItem(itemId, itemValue.getValue(), itemSchema.getValueType(), resultSchema.getValueType(), fieldSemanticSchema.getValueType()));
                }
                return resultMap;
            }
            case UNION: {
                int typeIdx = new GenericData().resolveUnion(itemSchema, item);
                List unionSchemas = itemSchema.getTypes();
                Schema realItemSchema = (Schema)unionSchemas.get(typeIdx);
                Schema realResultSchema = resultSchema.getTypes().stream().filter(type -> type.getName().equals(realItemSchema.getName())).findFirst().orElse(DATA_TYPE_DISCOVERY_VALUE_LEVEL_SCHEMA);
                Schema realSemanticSchema = (Schema)fieldSemanticSchema.getTypes().get(typeIdx);
                return this.analyzeItem(AvroUtils.itemId((String)itemId, (String)realItemSchema.getName()), item, realItemSchema, realResultSchema, realSemanticSchema);
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                GenericData.Record semRecord = new GenericData.Record(DATA_TYPE_DISCOVERY_VALUE_LEVEL_SCHEMA);
                semRecord.put(DATA_TYPE_FIELD, (Object)this.analyzeLeafValue(itemId, item, itemSchema));
                return semRecord;
            }
        }
        throw new IllegalStateException("Unexpected value: " + itemSchema.getType());
    }

    private DataTypeEnum analyzeLeafValue(String itemId, Object value, Schema itemSchema) {
        DataTypeEnum type;
        if (!this.frequentDatePatterns.containsKey(itemId)) {
            this.frequentDatePatterns.put(itemId, new SortedList());
        }
        if (this.dataTypeResults.get(itemId) == null) {
            this.dataTypeResults.put(itemId, new DataTypeOccurences());
        }
        DataTypeOccurences dataType = this.dataTypeResults.get(itemId);
        if (value != null) {
            type = this.getNativeDataType(value, itemSchema);
            if (this.isLogicalDate(itemSchema) || DataTypeEnum.STRING.equals((Object)type) && SystemDateTimePatternManager.isDate(value.toString(), this.frequentDatePatterns.get(itemId))) {
                type = DataTypeEnum.DATE;
            }
        } else {
            type = DataTypeEnum.NULL;
        }
        dataType.increment(type);
        return type;
    }

    private DataTypeEnum getNativeDataType(Object itemValue, Schema itemSchema) {
        switch (itemSchema.getType()) {
            case BOOLEAN: {
                return DataTypeEnum.BOOLEAN;
            }
            case FLOAT: 
            case DOUBLE: {
                return DataTypeEnum.DOUBLE;
            }
            case INT: 
            case LONG: {
                return DataTypeEnum.INTEGER;
            }
            case NULL: {
                return DataTypeEnum.NULL;
            }
        }
        return TypeInferenceUtils.getNativeDataType(itemValue.toString());
    }

    private boolean isLogicalDate(Schema itemSchema) {
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)itemSchema);
        return logicalType != null && DATE_RELATED_LOGICAL_TYPES.contains(logicalType);
    }

    public Schema getResult() {
        if (this.outputSemanticSchema == null) {
            return null;
        }
        for (Schema.Field field : this.outputSemanticSchema.getFields()) {
            this.updateDatatype(field.schema(), field.name());
        }
        return this.outputSemanticSchema;
    }

    private void updateDatatype(Schema schema, String fieldName) {
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    this.updateDatatype(field.schema(), AvroUtils.itemId((String)fieldName, (String)field.name()));
                }
                break;
            }
            case ARRAY: {
                this.updateDatatype(schema.getElementType(), fieldName);
                break;
            }
            case MAP: {
                this.updateDatatype(schema.getValueType(), fieldName);
                break;
            }
            case UNION: {
                if (this.dataTypeResults.containsKey(fieldName)) {
                    try {
                        schema.addProp(DATA_TYPE_FIELD, this.dataTypeResults.get(fieldName).getTypeFrequencies());
                    }
                    catch (AvroRuntimeException e) {
                        System.out.println("Failed to add prop to field " + fieldName + ".");
                    }
                }
                for (Schema unionSchema : schema.getTypes()) {
                    this.updateDatatype(unionSchema, AvroUtils.itemId((String)fieldName, (String)unionSchema.getName()));
                }
                break;
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                if (!this.dataTypeResults.containsKey(fieldName)) break;
                HashMap aggregate = new HashMap();
                this.dataTypeResults.get(fieldName).getTypeFrequencies().entrySet().stream().filter(entry -> !((DataTypeEnum)((Object)((Object)entry.getKey()))).equals((Object)DataTypeEnum.EMPTY)).max(entryComparator).map(entry -> {
                    aggregate.put(DATA_TYPE_FIELD, entry.getKey());
                    return null;
                });
                ArrayList matchings = new ArrayList();
                this.dataTypeResults.get(fieldName).getTypeFrequencies().forEach((key, value) -> {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put(DATA_TYPE_FIELD, key);
                    result.put(TOTAL_FIELD, value);
                    matchings.add(result);
                });
                aggregate.put(MATCHINGS_FIELD, matchings);
                try {
                    schema.addProp(DATA_TYPE_AGGREGATE, aggregate);
                    break;
                }
                catch (AvroRuntimeException e) {
                    System.out.println("Failed to add prop to referenced type " + fieldName + ". The analyzer is not supporting schema with referenced types.");
                }
            }
        }
    }

    public List<Schema> getResults() {
        return Collections.singletonList(this.getResult());
    }

    public void close() throws Exception {
    }
}

