/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataTypeEnum {
    BOOLEAN,
    INTEGER,
    DOUBLE,
    STRING,
    DATE,
    TIME,
    EMPTY,
    NULL;

    private static final Logger LOGGER;
    public static Comparator<DataTypeEnum> dataTypeEnumComparator;

    public static DataTypeEnum get(String typeName) {
        try {
            return DataTypeEnum.valueOf(typeName.toUpperCase());
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return STRING;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataTypeEnum.class);
        dataTypeEnumComparator = new Comparator<DataTypeEnum>(){

            @Override
            public int compare(DataTypeEnum dataTypeEnum, DataTypeEnum t1) {
                if (t1.equals((Object)EMPTY)) {
                    if (dataTypeEnum.equals((Object)EMPTY)) {
                        return 0;
                    }
                    return 1;
                }
                if (dataTypeEnum.equals((Object)EMPTY)) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

