/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Map;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class DataTypeOccurences
implements Serializable {
    private static final long serialVersionUID = -736825123668340428L;
    private Map<DataTypeEnum, Long> typeOccurences = new EnumMap<DataTypeEnum, Long>(DataTypeEnum.class);

    public Map<DataTypeEnum, Long> getTypeFrequencies() {
        return this.typeOccurences;
    }

    public DataTypeEnum getSuggestedType() {
        return this.getDominantType(0.5);
    }

    private DataTypeEnum getDominantType(double typeThreshold) {
        ArrayList<Map.Entry<DataTypeEnum, Long>> sortedTypeOccurrences = new ArrayList<Map.Entry<DataTypeEnum, Long>>();
        long count = 0L;
        for (Map.Entry<DataTypeEnum, Long> entry : this.typeOccurences.entrySet()) {
            DataTypeEnum type = entry.getKey();
            if (DataTypeEnum.EMPTY.equals((Object)type)) continue;
            count += entry.getValue().longValue();
            sortedTypeOccurrences.add(entry);
        }
        if (count != 0L) {
            if (this.typeOccurences.containsKey((Object)DataTypeEnum.DOUBLE) && this.typeOccurences.containsKey((Object)DataTypeEnum.INTEGER)) {
                long doubleOccurrences = this.typeOccurences.get((Object)DataTypeEnum.DOUBLE) + this.typeOccurences.get((Object)DataTypeEnum.INTEGER);
                this.typeOccurences.put(DataTypeEnum.DOUBLE, doubleOccurrences);
            }
            Comparator<Map.Entry<DataTypeEnum, Long>> decreasingOccurrenceComparator = new Comparator<Map.Entry<DataTypeEnum, Long>>(){

                @Override
                public int compare(Map.Entry<DataTypeEnum, Long> o1, Map.Entry<DataTypeEnum, Long> o2) {
                    return Long.compare(o2.getValue(), o1.getValue());
                }
            };
            Collections.sort(sortedTypeOccurrences, decreasingOccurrenceComparator);
            double occurrenceThreshold = typeThreshold * (double)count;
            if ((double)((Long)((Map.Entry)sortedTypeOccurrences.get(0)).getValue()).longValue() >= occurrenceThreshold) {
                return (DataTypeEnum)((Object)((Map.Entry)sortedTypeOccurrences.get(0)).getKey());
            }
        }
        return DataTypeEnum.STRING;
    }

    public void increment(DataTypeEnum type) {
        if (!this.typeOccurences.containsKey((Object)type)) {
            this.typeOccurences.put(type, 1L);
        } else {
            this.typeOccurences.put(type, this.typeOccurences.get((Object)type) + 1L);
        }
    }
}

