/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataquality.statistics.type;

import java.math.BigInteger;
import java.util.regex.Pattern;
import org.talend.dataquality.statistics.datetime.SystemDateTimePatternManager;
import org.talend.dataquality.statistics.type.DataTypeEnum;

public class TypeInferenceUtils {
    private static final Pattern patternInteger = Pattern.compile("^([-\uff0d+\uff0b])?[0-9\uff10-\uff19]+$");
    private static final Pattern patternDouble = Pattern.compile("^[-+\uff0d\uff0b]?([0-9\uff10-\uff19]+([,.\uff0e][0-9\uff10-\uff19]+)?|([0-9]{1,3}(((,[0-9]{3})*(\\.[0-9]+)?|((\\.[0-9]{3})*|([ \u00a0\u2007\u202f][0-9]{3})*)(,[0-9]+)?))))([ \u3000]?[eE\uff45\uff25][-+\uff0d\uff0b]?[0-9\uff10-\uff19]+)?([ \u3000]?[%\uff05])?$");

    public static boolean isDouble(String value) {
        return !TypeInferenceUtils.isNullOrBlank(value) && patternDouble.matcher(value).matches();
    }

    public static boolean isInteger(String value) {
        return !TypeInferenceUtils.isNullOrBlank(value) && patternInteger.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        return TypeInferenceUtils.isDouble(value) || TypeInferenceUtils.isInteger(value);
    }

    public static BigInteger getBigInteger(String value) {
        BigInteger bint = null;
        try {
            bint = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bint;
    }

    public static boolean isBoolean(String value) {
        if (TypeInferenceUtils.isNullOrBlank(value)) {
            return false;
        }
        return !(value.trim().length() != 4 && value.trim().length() != 5 || !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value));
    }

    public static boolean isDate(String value) {
        return SystemDateTimePatternManager.isDate(value);
    }

    public static boolean isTime(String value) {
        return SystemDateTimePatternManager.isTime(value);
    }

    public static boolean isNullOrBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isValid(DataTypeEnum type, String value) {
        switch (type) {
            case BOOLEAN: {
                return TypeInferenceUtils.isBoolean(value);
            }
            case INTEGER: {
                return TypeInferenceUtils.isInteger(value);
            }
            case DOUBLE: {
                return TypeInferenceUtils.isDouble(value);
            }
            case DATE: {
                return TypeInferenceUtils.isDate(value);
            }
            case STRING: {
                return true;
            }
        }
        return false;
    }

    public static DataTypeEnum getDataType(String value) {
        DataTypeEnum dataTypeEnum = TypeInferenceUtils.getNativeDataType(value);
        if (DataTypeEnum.STRING.equals((Object)dataTypeEnum)) {
            if (TypeInferenceUtils.isDate(value)) {
                dataTypeEnum = DataTypeEnum.DATE;
            } else if (TypeInferenceUtils.isTime(value)) {
                dataTypeEnum = DataTypeEnum.TIME;
            }
        }
        return dataTypeEnum;
    }

    public static DataTypeEnum getNativeDataType(String value) {
        if (TypeInferenceUtils.isNullOrEmpty(value)) {
            return DataTypeEnum.EMPTY;
        }
        if (TypeInferenceUtils.isBoolean(value)) {
            return DataTypeEnum.BOOLEAN;
        }
        if (TypeInferenceUtils.isInteger(value)) {
            return DataTypeEnum.INTEGER;
        }
        if (TypeInferenceUtils.isDouble(value)) {
            return DataTypeEnum.DOUBLE;
        }
        return DataTypeEnum.STRING;
    }
}

