/*
 * Decompiled with CFR 0.152.
 */
package app.utils.security.client;

import app.utils.config.AppConfig;
import app.utils.security.client.AsyncClientInterceptor;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppClientAuth {
    private static final Logger LOG = LoggerFactory.getLogger(AppClientAuth.class);
    private static final String DEFAULT_LEGACY_PUBLIC_CLIENT_ID = "aFSloIZSXHRQtA";
    private static final String DEFAULT_LEGACY_OIDC_SCOPE = "openid";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, String>> HASH_MAP_TYPE_REF = new TypeReference<HashMap<String, String>>(){};
    private static final HttpClient httpClient = HttpClient.newHttpClient();

    public static String getLegacyOIDCAuthHeader(String oidcUsername, String oidcPassword) throws Exception {
        Map responseMap;
        if (oidcUsername == null || oidcUsername.isEmpty()) {
            throw new IllegalArgumentException("OIDC username is a required parameter");
        }
        if (oidcPassword == null) {
            throw new IllegalArgumentException("OIDC password is a required parameter");
        }
        String tokenEndpoint = AppConfig.getString("token.endpoint");
        if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
            throw new Exception("Token endpoint setting is null or empty");
        }
        String clientId = AppConfig.getString("public.client.id");
        if (clientId == null) {
            clientId = DEFAULT_LEGACY_PUBLIC_CLIENT_ID;
        } else if (clientId.isEmpty()) {
            throw new Exception("OIDC client ID setting is empty");
        }
        String scope = AppConfig.getString("scope");
        if (scope == null) {
            scope = DEFAULT_LEGACY_OIDC_SCOPE;
        }
        String requestBody = "grant_type=password&scope=" + scope + "&username=" + oidcUsername + "&password=" + oidcPassword + "&client_id=" + clientId;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(tokenEndpoint)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
        HttpResponse<InputStream> httpResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        try {
            responseMap = (Map)OBJECT_MAPPER.readValue(httpResponse.body(), HASH_MAP_TYPE_REF);
        }
        catch (Exception ex) {
            throw new Exception("Can not parse response from  OIDC Access Token service: ", ex);
        }
        if (httpResponse.statusCode() != 200) {
            if (responseMap.get("error") != null) {
                throw new Exception("OIDC Access Token request failed: " + (String)responseMap.get("error"));
            }
            throw new Exception("OIDC token endpoint replied with HTTTP " + httpResponse.statusCode() + " on token request");
        }
        if (!"Bearer".equals(responseMap.get("token_type"))) {
            throw new Exception("Token returned from OIDC Access Token service is not of Bearer type");
        }
        return "Bearer " + (String)responseMap.get("access_token");
    }

    public static void setLegacyOIDCAuthHeader(AbstractJAXRSFactoryBean clientFactory, String username, String password) {
        GetAuthHeaderFun authHeaderFun = () -> AppClientAuth.getLegacyOIDCAuthHeader(username, password);
        AsyncClientInterceptor outInterceptor = new AsyncClientInterceptor(authHeaderFun);
        clientFactory.getOutInterceptors().add(outInterceptor);
    }

    public static String getJWTAuthHeader() throws Exception {
        ClientSecretBasic clientAuth;
        ClientID clientID = new ClientID(AppConfig.getString("oauth.client.id"));
        Secret clientSecret = new Secret(AppConfig.getString("oauth.client.secret"));
        URI tokenEndpoint = new URI(AppConfig.getString("oauth.provider.token.endpoint"));
        TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)(clientAuth = new ClientSecretBasic(clientID, clientSecret)), (AuthorizationGrant)new ClientCredentialsGrant());
        HTTPResponse httpResponse = request.toHTTPRequest().send();
        if (httpResponse.getStatusCode() != 200) {
            throw new Exception(String.format("JWT Access Token request failed with HTTP status code %d: %s ", httpResponse.getStatusCode(), httpResponse.getContent()));
        }
        TokenResponse tokenResponse = TokenResponse.parse((HTTPResponse)httpResponse);
        AccessToken accessToken = ((AccessTokenResponse)tokenResponse).getTokens().getAccessToken();
        return String.format("%s %s", accessToken.getType().getValue(), accessToken.getValue());
    }

    public static void setJWTAuthHeader(AbstractJAXRSFactoryBean clientFactory) {
        GetAuthHeaderFun authHeaderFun = () -> AppClientAuth.getJWTAuthHeader();
        AsyncClientInterceptor outInterceptor = new AsyncClientInterceptor(authHeaderFun);
        clientFactory.getOutInterceptors().add(outInterceptor);
    }

    @FunctionalInterface
    public static interface GetAuthHeaderFun {
        public String generate() throws Exception;
    }
}

