/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.asm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.runtime.reflect.JavaVersion;

public final class Unsafes {
    private static final Object UNSAFE;
    private static final Object INTERNAL_UNSAFE;
    private static final Method UNSAFE_DEFINE_CLASS;

    public static <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes) {
        if (ConfigurableClassLoader.class.isInstance(classLoader)) {
            return ((ConfigurableClassLoader)ConfigurableClassLoader.class.cast(classLoader)).registerBytecode(proxyName.replace('/', '.'), proxyBytes);
        }
        Class<?> clazz = classLoader.getClass();
        AccessibleObject defineClassMethod = null;
        do {
            try {
                defineClassMethod = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (defineClassMethod == null && clazz != Object.class);
        if (defineClassMethod != null && !defineClassMethod.isAccessible()) {
            try {
                ((Method)defineClassMethod).setAccessible(true);
            }
            catch (RuntimeException re) {
                defineClassMethod = null;
            }
        }
        try {
            Class definedClass;
            if (defineClassMethod != null) {
                definedClass = (Class)((Method)defineClassMethod).invoke(classLoader, proxyName, proxyBytes, 0, proxyBytes.length);
            } else {
                Objects.requireNonNull(UNSAFE_DEFINE_CLASS, "No Unsafe.defineClass available");
                definedClass = (Class)UNSAFE_DEFINE_CLASS.invoke(UNSAFE, proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null);
            }
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (InvocationTargetException le) {
            if (LinkageError.class.isInstance(le.getCause())) {
                try {
                    return Class.forName(proxyName.replace('/', '.'), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new IllegalStateException(le.getCause());
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Generated
    private Unsafes() {
    }

    static {
        Class unsafeClass;
        int javaVersion = JavaVersion.major();
        if (javaVersion > 8 && javaVersion < 17) {
            try {
                Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe");
                Field field = unsafeClazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Object unsafe = field.get(null);
                Method putObjectVolatile = unsafeClazz.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
                Method staticFieldOffset = unsafeClazz.getDeclaredMethod("staticFieldOffset", Field.class);
                Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
                Field loggerField = loggerClass.getDeclaredField("logger");
                Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
                putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
            }
            catch (Exception e) {
                System.err.println("Disabling unsafe warnings failed: " + e.getMessage());
            }
        }
        try {
            unsafeClass = AccessController.doPrivileged(() -> (Class)Stream.of(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()).flatMap(classloader -> Stream.of("sun.misc.Unsafe", "jdk.internal.misc.Unsafe").flatMap(name -> {
                try {
                    return Stream.of(classloader.loadClass((String)name));
                }
                catch (ClassNotFoundException e) {
                    return Stream.empty();
                }
            })).findFirst().orElseThrow(() -> new IllegalStateException("Cannot get Unsafe")));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get Unsafe class", e);
        }
        UNSAFE = AccessController.doPrivileged(() -> {
            try {
                Field field = unsafeClass.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        INTERNAL_UNSAFE = AccessController.doPrivileged(() -> {
            try {
                Field theInternalUnsafe = unsafeClass.getDeclaredField("theInternalUnsafe");
                theInternalUnsafe.setAccessible(true);
                return theInternalUnsafe.get(null).getClass();
            }
            catch (Exception notJ11OrMore) {
                return UNSAFE;
            }
        });
        if (UNSAFE != null) {
            UNSAFE_DEFINE_CLASS = AccessController.doPrivileged(() -> {
                try {
                    return INTERNAL_UNSAFE.getClass().getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                }
                catch (Exception e) {
                    return null;
                }
            });
            try {
                Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
                rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).setAccessible(true);
                rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class).setAccessible(true);
            }
            catch (Exception e) {
                try {
                    Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
                    Method objectFieldOffset = UNSAFE.getClass().getDeclaredMethod("objectFieldOffset", Field.class);
                    Method putBoolean = UNSAFE.getClass().getDeclaredMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                    objectFieldOffset.setAccessible(true);
                    long accOffset = (Long)Long.class.cast(objectFieldOffset.invoke(UNSAFE, AccessibleObject.class.getDeclaredField("override")));
                    putBoolean.invoke(UNSAFE, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE), accOffset, true);
                    putBoolean.invoke(UNSAFE, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), accOffset, true);
                }
                catch (Exception exception) {}
            }
        } else {
            UNSAFE_DEFINE_CLASS = null;
        }
    }
}

