/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.api;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;

@FunctionalInterface
public interface ComponentInstantiator {
    public Lifecycle instantiate(Map<String, String> var1, int var2);

    public static class ComponentNameFinder
    implements MetaFinder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ComponentNameFinder.class);
        private final String componentName;

        public ComponentNameFinder(String componentName) {
            this.componentName = Optional.ofNullable(componentName).map(String::trim).orElse("");
        }

        @Override
        public Optional<? extends ComponentFamilyMeta.BaseMeta> filter(Map<String, ? extends ComponentFamilyMeta.BaseMeta> source) {
            if (!source.containsKey(this.componentName)) {
                log.debug("Can't find component name {}", (Object)this.componentName);
            }
            return Optional.ofNullable(source.get(this.componentName));
        }
    }

    public static class BuilderDefault
    implements Builder {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(BuilderDefault.class);
        private final Supplier<Stream<ContainerComponentRegistry>> registrySupplier;

        @Override
        public ComponentInstantiator build(String familyName, MetaFinder finder, ComponentManager.ComponentType componentType) {
            Stream<ContainerComponentRegistry> registries = this.registrySupplier.get();
            if (registries == null) {
                return null;
            }
            String sanitizedFamilyName = Optional.ofNullable(familyName).map(String::trim).orElse("");
            return registries.map(registry -> registry.findComponentFamily(sanitizedFamilyName)).filter(Objects::nonNull).peek(cm -> log.debug("Family found {} plugin {}", (Object)sanitizedFamilyName, (Object)cm.getPlugin())).map(componentType::findMeta).map(map -> finder.filter((Map<String, ? extends ComponentFamilyMeta.BaseMeta>)map)).filter(Optional::isPresent).map(Optional::get).findFirst().map(c -> c::instantiate).orElse(null);
        }

        @Generated
        public BuilderDefault(Supplier<Stream<ContainerComponentRegistry>> registrySupplier) {
            this.registrySupplier = registrySupplier;
        }
    }

    @FunctionalInterface
    public static interface Builder {
        public ComponentInstantiator build(String var1, MetaFinder var2, ComponentManager.ComponentType var3);
    }

    public static interface MetaFinder {
        public Optional<? extends ComponentFamilyMeta.BaseMeta> filter(Map<String, ? extends ComponentFamilyMeta.BaseMeta> var1);

        public static MetaFinder ofComponent(String name) {
            return new ComponentNameFinder(name);
        }
    }
}

