/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.xbean.converter;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.xbean.propertyeditor.AbstractConverter;

public class ZonedDateTimeConverter
extends AbstractConverter {
    private static final LocalTime NO_TIME = LocalTime.of(0, 0);
    private static final LocalDate NO_DATE = LocalDate.of(1970, 1, 1);
    private static final ZoneId UTC = ZoneId.of("UTC");

    public ZonedDateTimeConverter() {
        super(ZonedDateTime.class);
    }

    protected Object toObjectImpl(String data) {
        if (data.isEmpty()) {
            return null;
        }
        Object text = data.replace('/', '-');
        switch (((String)text).length()) {
            case 10: {
                return ZonedDateTime.of(LocalDate.parse((CharSequence)text), NO_TIME, ZoneId.of("UTC"));
            }
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 18: {
                return ZonedDateTime.of(NO_DATE, LocalTime.parse((CharSequence)text), UTC);
            }
        }
        text = ((String)text).replace(' ', 'T');
        if (((String)text).contains("+") || ((String)text).contains("[")) {
            int keepAsIt = ((String)text).indexOf(43);
            if (keepAsIt < 0) {
                keepAsIt = ((String)text).indexOf(91);
            }
            text = ((String)text).substring(0, keepAsIt) + data.substring(keepAsIt);
            return ZonedDateTime.parse((CharSequence)text);
        }
        LocalDateTime dateTime = LocalDateTime.parse((CharSequence)(((String)text).endsWith("Z") ? ((String)text).substring(0, ((String)text).length() - 1) : text));
        return ZonedDateTime.of(dateTime.toLocalDate(), dateTime.toLocalTime(), UTC);
    }
}

