/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.constraint.Max;
import org.talend.sdk.component.api.configuration.constraint.Min;
import org.talend.sdk.component.api.configuration.ui.widget.DateTime;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.configuration.Configuration;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Primitives;
import org.talend.sdk.component.runtime.manager.reflect.StringCompatibleTypes;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.spi.parameter.ParameterExtensionEnricher;

public class ParameterModelService {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final Collection<ParameterExtensionEnricher> enrichers;
    private final PropertyEditorRegistry registry;
    private final Map<Type, Collection<Annotation>> implicitAnnotationsMapping;

    protected ParameterModelService(Collection<ParameterExtensionEnricher> enrichers, PropertyEditorRegistry registry) {
        this.enrichers = enrichers;
        this.registry = registry;
        this.implicitAnnotationsMapping = enrichers.stream().flatMap(enricher -> enricher.getImplicitAnnotationForTypes().entrySet().stream()).filter(e -> e.getValue() != null && !((Collection)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (l1, l2) -> Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toSet())));
    }

    public ParameterModelService(PropertyEditorRegistry registry) {
        this(StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(ParameterExtensionEnricher.class).iterator(), 1024), false).collect(Collectors.toList()), registry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isService(Param parameter) {
        Class type;
        if (Class.class.isInstance(parameter.type)) {
            type = (Class)Class.class.cast(parameter.type);
        } else {
            if (!ParameterizedType.class.isInstance(parameter.type)) return false;
            Type rawType = ((ParameterizedType)ParameterizedType.class.cast(parameter.type)).getRawType();
            if (!Class.class.isInstance(rawType)) return false;
            type = (Class)Class.class.cast(rawType);
        }
        if (parameter.isAnnotationPresent(Option.class)) return false;
        if (type.isAnnotationPresent(Service.class)) return true;
        if (parameter.isAnnotationPresent(Configuration.class)) return true;
        if (type.isAnnotationPresent(Internationalized.class)) return true;
        if (Stream.of(type.getMethods()).anyMatch(m -> m.isAnnotationPresent(Request.class))) return true;
        if (type.getName().startsWith("org.talend.sdk.component.")) {
            if (type.getName().contains(".service.")) return true;
        }
        if (!type.getName().startsWith("javax.")) return false;
        return true;
    }

    public List<ParameterMeta> buildParameterMetas(Stream<Param> parameters, Class<?> declaringClass, String i18nPackage, boolean ignoreI18n, BaseParameterEnricher.Context context) {
        return parameters.filter(p -> !this.isService((Param)p)).map(parameter -> {
            String name = this.findName((AnnotatedElement)parameter, parameter.name);
            return this.buildParameter(name, name, new ParameterMeta.Source(){
                final /* synthetic */ Param val$parameter;
                final /* synthetic */ Class val$declaringClass;
                {
                    this.val$parameter = param;
                    this.val$declaringClass = clazz;
                }

                @Override
                public String name() {
                    return this.val$parameter.name;
                }

                @Override
                public Class<?> declaringClass() {
                    return this.val$declaringClass;
                }
            }, parameter.type, (Annotation[])Stream.concat(this.extractTypeAnnotation((Param)parameter), Stream.of(parameter.getAnnotations())).distinct().toArray(Annotation[]::new), new ArrayList<String>(Collections.singletonList(i18nPackage)), ignoreI18n, context);
        }).collect(Collectors.toList());
    }

    private Stream<Annotation> extractTypeAnnotation(Param parameter) {
        ParameterizedType parameterizedType;
        if (Class.class.isInstance(parameter.type)) {
            return Stream.of(((Class)Class.class.cast(parameter.type)).getAnnotations());
        }
        if (ParameterizedType.class.isInstance(parameter.type) && Class.class.isInstance((parameterizedType = (ParameterizedType)ParameterizedType.class.cast(parameter.type)).getRawType())) {
            return Stream.of(((Class)Class.class.cast(parameterizedType.getRawType())).getAnnotations());
        }
        return Stream.empty();
    }

    private List<ParameterMeta> doBuildParameterMetas(Executable executable, String i18nPackage, boolean ignoreI18n, BaseParameterEnricher.Context context) {
        return this.buildParameterMetas(Stream.of(executable.getParameters()).map(Param::new), executable.getDeclaringClass(), i18nPackage, ignoreI18n, context);
    }

    public List<ParameterMeta> buildServiceParameterMetas(Executable executable, String i18nPackage, BaseParameterEnricher.Context context) {
        return this.doBuildParameterMetas(executable, i18nPackage, true, context);
    }

    public List<ParameterMeta> buildParameterMetas(Executable executable, String i18nPackage, BaseParameterEnricher.Context context) {
        return this.doBuildParameterMetas(executable, i18nPackage, false, context);
    }

    protected ParameterMeta buildParameter(String name, String prefix, ParameterMeta.Source source, Type genericType, Annotation[] annotations, Collection<String> i18nPackages, boolean ignoreI18n, BaseParameterEnricher.Context context) {
        ParameterMeta.Type type = this.findType(genericType);
        String normalizedPrefix = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        ArrayList<ParameterMeta> nested = new ArrayList<ParameterMeta>();
        ArrayList<String> proposals = new ArrayList<String>();
        switch (type) {
            case OBJECT: {
                this.addI18nPackageIfPossible(i18nPackages, genericType);
                List<ParameterMeta> meta = this.buildParametersMetas(name, normalizedPrefix + ".", genericType, annotations, i18nPackages, ignoreI18n, context);
                meta.sort(Comparator.comparing(ParameterMeta::getName));
                nested.addAll(meta);
                break;
            }
            case ARRAY: {
                Class<?> nestedType = Class.class.isInstance(genericType) && ((Class)Class.class.cast(genericType)).isArray() ? ((Class)Class.class.cast(genericType)).getComponentType() : ((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0];
                this.addI18nPackageIfPossible(i18nPackages, nestedType);
                nested.addAll(this.buildParametersMetas(name + "[${index}]", normalizedPrefix + "[${index}].", nestedType, Class.class.isInstance(nestedType) ? ((Class)Class.class.cast(nestedType)).getAnnotations() : NO_ANNOTATIONS, i18nPackages, ignoreI18n, context));
                break;
            }
            case ENUM: {
                this.addI18nPackageIfPossible(i18nPackages, genericType);
                proposals.addAll(Stream.of((Enum[])((Class)genericType).getEnumConstants()).map(Enum::name).collect(Collectors.toList()));
                break;
            }
        }
        return new ParameterMeta(source, genericType, type, normalizedPrefix, name, i18nPackages.toArray(new String[i18nPackages.size()]), nested, proposals, this.buildExtensions(name, genericType, annotations, context), false);
    }

    private void addI18nPackageIfPossible(Collection<String> i18nPackages, Type type) {
        Package typePck;
        if (Class.class.isInstance(type) && (typePck = ((Class)Class.class.cast(type)).getPackage()) != null && !typePck.getName().isEmpty() && !i18nPackages.contains(typePck.getName())) {
            i18nPackages.add(typePck.getName());
        }
    }

    private Map<String, String> buildExtensions(String name, Type genericType, Annotation[] annotations, BaseParameterEnricher.Context context) {
        return this.getAnnotations(genericType, annotations).distinct().flatMap(a -> this.enrichers.stream().map(e -> {
            if (BaseParameterEnricher.class.isInstance(e)) {
                BaseParameterEnricher bpe = (BaseParameterEnricher)BaseParameterEnricher.class.cast(e);
                return bpe.withContext(context, () -> bpe.onParameterAnnotation(name, genericType, (Annotation)a));
            }
            return e.onParameterAnnotation(name, genericType, a);
        })).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
            if (a.equals(b)) {
                return a;
            }
            throw new IllegalArgumentException("Ambiguous metadata: '" + a + "'/'" + b + "'");
        }));
    }

    private Stream<Annotation> getAnnotations(Type type, Annotation[] annotations) {
        HashSet<Class> overwrittableAnnotations = new HashSet<Class>(Arrays.asList(Min.class, Max.class, DateTime.class));
        Set skipImplicit = Stream.of(annotations).map(Annotation::annotationType).filter(overwrittableAnnotations::contains).collect(Collectors.toSet());
        return Stream.concat(this.getReflectionAnnotations(type, annotations), ((Collection)this.implicitAnnotationsMapping.getOrDefault(type, Collections.emptyList())).stream().filter(it -> !skipImplicit.contains(it.annotationType())));
    }

    private Stream<Annotation> getReflectionAnnotations(Type genericType, Annotation[] annotations) {
        return Stream.concat(Stream.of(annotations), Class.class.isInstance(genericType) ? this.getClassAnnotations(genericType, annotations) : (this.hasAClassFirstParameter(genericType) ? this.getClassAnnotations(((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0], annotations) : Stream.empty()));
    }

    private boolean hasAClassFirstParameter(Type genericType) {
        return ParameterizedType.class.isInstance(genericType) && ((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments().length == 1 && Class.class.isInstance(((ParameterizedType)ParameterizedType.class.cast(genericType)).getActualTypeArguments()[0]);
    }

    private Stream<Annotation> getClassAnnotations(Type genericType, Annotation[] annotations) {
        return Stream.of(((Class)Class.class.cast(genericType)).getAnnotations()).filter(a -> Stream.of(annotations).noneMatch(o -> o.annotationType() == a.annotationType()));
    }

    private List<ParameterMeta> buildParametersMetas(final String name, String prefix, final Type type, Annotation[] annotations, Collection<String> i18nPackages, boolean ignoreI18n, BaseParameterEnricher.Context context) {
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (!Class.class.isInstance(pt.getRawType())) {
                throw new IllegalArgumentException("Unsupported raw type in ParameterizedType parameter: " + pt);
            }
            Class raw = (Class)Class.class.cast(pt.getRawType());
            if (Collection.class.isAssignableFrom(raw)) {
                if (!Class.class.isInstance(pt.getActualTypeArguments()[0])) {
                    throw new IllegalArgumentException("Unsupported list: " + pt + ", ensure to use a concrete class as generic");
                }
                return this.buildParametersMetas(name, prefix, (Type)Class.class.cast(type), annotations, i18nPackages, ignoreI18n, context);
            }
            if (Map.class.isAssignableFrom(raw)) {
                if (!Class.class.isInstance(pt.getActualTypeArguments()[0]) || !Class.class.isInstance(pt.getActualTypeArguments()[1])) {
                    throw new IllegalArgumentException("Unsupported map: " + pt + ", ensure to use a concrete class as generics");
                }
                return Stream.concat(this.buildParametersMetas(name + ".key[${index}]", prefix + "key[${index}].", (Type)Class.class.cast(pt.getActualTypeArguments()[0]), annotations, i18nPackages, ignoreI18n, context).stream(), this.buildParametersMetas(name + ".value[${index}]", prefix + "value[${index}].", (Type)Class.class.cast(pt.getActualTypeArguments()[1]), annotations, i18nPackages, ignoreI18n, context).stream()).collect(Collectors.toList());
            }
        }
        if (Class.class.isInstance(type)) {
            switch (this.findType(type)) {
                case ENUM: 
                case STRING: 
                case NUMBER: 
                case BOOLEAN: {
                    return Collections.singletonList(this.buildParameter(name, prefix, new ParameterMeta.Source(){

                        @Override
                        public String name() {
                            return name;
                        }

                        @Override
                        public Class<?> declaringClass() {
                            return (Class)Class.class.cast(type);
                        }
                    }, type, annotations, i18nPackages, ignoreI18n, context));
                }
            }
            return this.buildObjectParameters(prefix, (Class)Class.class.cast(type), i18nPackages, ignoreI18n, context);
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type);
    }

    private List<ParameterMeta> buildObjectParameters(String prefix, Class<?> type, Collection<String> i18nPackages, boolean ignoreI18n, BaseParameterEnricher.Context context) {
        HashMap fields = new HashMap();
        ArrayList<ParameterMeta> out = new ArrayList<ParameterMeta>();
        for (Class<?> current = type; current != null && current != Object.class; current = current.getSuperclass()) {
            out.addAll(Stream.of(current.getDeclaredFields()).filter(f -> f.isAnnotationPresent(Option.class)).filter(f -> !"$jacocoData".equals(f.getName()) && !Modifier.isStatic(f.getModifiers()) && (f.getModifiers() & 0x1000) == 0).filter(f -> fields.putIfAbsent(f.getName(), f) == null).map(f -> {
                String name = this.findName((AnnotatedElement)f, f.getName());
                String path = prefix + name;
                return this.buildParameter(name, path + ".", new ParameterMeta.Source(){
                    final /* synthetic */ Field val$f;
                    {
                        this.val$f = field;
                    }

                    @Override
                    public String name() {
                        return this.val$f.getName();
                    }

                    @Override
                    public Class<?> declaringClass() {
                        return this.val$f.getDeclaringClass();
                    }
                }, f.getGenericType(), f.getAnnotations(), i18nPackages, ignoreI18n, context);
            }).collect(Collectors.toList()));
        }
        return out;
    }

    public String findName(AnnotatedElement parameter, String defaultName) {
        return Optional.ofNullable(parameter.getAnnotation(Option.class)).map(Option::value).filter(v -> !v.isEmpty()).orElse(defaultName);
    }

    private ParameterMeta.Type findType(Type type) {
        if (Class.class.isInstance(type)) {
            Class clazz = (Class)Class.class.cast(type);
            if (Primitives.unwrap(clazz) == Boolean.TYPE) {
                return ParameterMeta.Type.BOOLEAN;
            }
            if (Primitives.unwrap(clazz) == Character.TYPE) {
                return ParameterMeta.Type.STRING;
            }
            if (clazz.isPrimitive() || Primitives.unwrap(clazz) != clazz) {
                return ParameterMeta.Type.NUMBER;
            }
            if (clazz.isEnum()) {
                return ParameterMeta.Type.ENUM;
            }
            if (clazz.isArray()) {
                return ParameterMeta.Type.ARRAY;
            }
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            if (Class.class.isInstance(pt.getRawType())) {
                Class raw = (Class)Class.class.cast(pt.getRawType());
                if (Collection.class.isAssignableFrom(raw)) {
                    return ParameterMeta.Type.ARRAY;
                }
                if (Map.class.isAssignableFrom(raw)) {
                    return ParameterMeta.Type.OBJECT;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + pt);
        }
        if (StringCompatibleTypes.isKnown(type, this.registry)) {
            return ParameterMeta.Type.STRING;
        }
        return ParameterMeta.Type.OBJECT;
    }

    public static class Param
    implements AnnotatedElement {
        private final Type type;
        private final String name;
        private final Annotation[] annotations;

        public Param(Type type, Annotation[] annotations, String name) {
            this.type = type;
            this.annotations = annotations;
            this.name = name;
        }

        public Param(Parameter parameter) {
            this(parameter.getParameterizedType(), parameter.getAnnotations(), parameter.getName());
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)((Annotation)Stream.of(this.getAnnotations()).filter(it -> it.annotationType() == annotationClass).findFirst().map(annotationClass::cast).orElse(null));
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }
    }
}

