/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import lombok.Generated;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.HttpClientFactory;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.manager.proxy.SerializationHandlerReplacer;
import org.talend.sdk.component.runtime.manager.reflect.Copiable;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.service.http.ExecutionContext;
import org.talend.sdk.component.runtime.manager.service.http.RequestParser;
import org.talend.sdk.component.runtime.reflect.Defaults;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class HttpClientFactoryImpl
implements HttpClientFactory,
Serializable {
    private final String plugin;
    private final ReflectionService reflections;
    private final Jsonb jsonb;
    private final Map<Class<?>, Object> services;

    public static <T> Collection<String> createErrors(Class<T> api) {
        ArrayList<String> errors = new ArrayList<String>();
        Collection methods = Stream.of(api.getMethods()).filter(m -> m.getDeclaringClass() == api && !m.isDefault()).collect(Collectors.toList());
        if (!HttpClient.class.isAssignableFrom(api)) {
            errors.add(api.getCanonicalName() + " should extends HttpClient");
        }
        errors.addAll(methods.stream().filter(m -> !m.isAnnotationPresent(Request.class)).map(m -> "No @Request on " + m).collect(Collectors.toList()));
        return errors;
    }

    public <T> T create(Class<T> api, String base) {
        if (!api.isInterface()) {
            throw new IllegalArgumentException(api + " is not an interface");
        }
        this.validate(api);
        HttpHandler handler = new HttpHandler(api.getName(), this.plugin, new RequestParser(this.reflections, this.jsonb, this.services));
        T instance = api.cast(Proxy.newProxyInstance(api.getClassLoader(), (Class[])Stream.of(api, HttpClient.class, Serializable.class, Copiable.class).distinct().toArray(Class[]::new), (InvocationHandler)handler));
        ((HttpClient)HttpClient.class.cast(instance)).base(base);
        return instance;
    }

    private <T> void validate(Class<T> api) {
        Collection<String> errors = HttpClientFactoryImpl.createErrors(api);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException("Invalid Http Proxy specification:\n" + errors.stream().collect(Collectors.joining("\n- ", "- ", "\n")));
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, HttpClientFactory.class.getName());
    }

    @Generated
    public HttpClientFactoryImpl(String plugin, ReflectionService reflections, Jsonb jsonb, Map<Class<?>, Object> services) {
        this.plugin = plugin;
        this.reflections = reflections;
        this.jsonb = jsonb;
        this.services = services;
    }

    private static class HttpHandler
    implements InvocationHandler,
    Serializable {
        private final String proxyType;
        private final String plugin;
        private String base;
        private final RequestParser requestParser;
        private volatile Map<Class<?>, Object> jaxbContexts;
        private volatile ConcurrentMap<Method, ExecutionContext> invokers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Copiable.class == method.getDeclaringClass()) {
                HttpHandler httpHandler = new HttpHandler(this.proxyType, this.plugin, this.requestParser);
                httpHandler.base = this.base;
                return Proxy.newProxyInstance(proxy.getClass().getClassLoader(), proxy.getClass().getInterfaces(), (InvocationHandler)httpHandler);
            }
            if (Defaults.isDefaultAndShouldHandle((Method)method)) {
                return Defaults.handleDefault(method.getDeclaringClass(), (Method)method, (Object)proxy, (Object[])args);
            }
            String methodName = method.getName();
            if (Object.class == method.getDeclaringClass()) {
                switch (methodName) {
                    case "equals": {
                        return args[0] != null && Proxy.isProxyClass(args[0].getClass()) && this.equals(Proxy.getInvocationHandler(args[0]));
                    }
                    case "toString": {
                        return "@Request " + this.base;
                    }
                }
                return this.delegate(method, args);
            }
            if (HttpClient.class == method.getDeclaringClass()) {
                switch (methodName) {
                    case "base": {
                        this.base = String.valueOf(args[0]);
                        return null;
                    }
                }
                throw new UnsupportedOperationException("HttpClient." + methodName);
            }
            if (!method.isAnnotationPresent(Request.class)) {
                return this.delegate(method, args);
            }
            if (this.invokers == null) {
                HttpHandler httpHandler = this;
                synchronized (httpHandler) {
                    if (this.invokers == null) {
                        this.invokers = new ConcurrentHashMap<Method, ExecutionContext>();
                        this.jaxbContexts = new ConcurrentHashMap();
                    }
                }
            }
            return this.invokers.computeIfAbsent(method, this.requestParser::parse).apply(this.base, args);
        }

        Object writeReplace() throws ObjectStreamException {
            return new SerializationHandlerReplacer(this.plugin, this.proxyType);
        }

        private Object delegate(Method method, Object[] args) {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException ite) {
                throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)ite);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }

        @Generated
        public String toString() {
            return "HttpClientFactoryImpl.HttpHandler(proxyType=" + this.proxyType + ", plugin=" + this.plugin + ", base=" + this.base + ", requestParser=" + this.requestParser + ", jaxbContexts=" + this.jaxbContexts + ", invokers=" + this.invokers + ")";
        }

        @Generated
        public HttpHandler(String proxyType, String plugin, RequestParser requestParser) {
            this.proxyType = proxyType;
            this.plugin = plugin;
            this.requestParser = requestParser;
        }
    }
}

