/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.enterprise.inject.spi.CDI;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.cxf.transport.servlet.ServletController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.server.front.memory.InMemoryResponse;

public class AsyncContextImpl
implements AsyncContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncContextImpl.class);
    private final ServletRequest request;
    private final InMemoryResponse response;
    private final boolean originalRequestAndResponse;
    private final Collection<AsyncListener> listeners = new ArrayList<AsyncListener>();
    private final ServletController controller;
    private long timeout;

    AsyncContext start() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, (ServletResponse)this.response);
        this.executeOnListeners(l -> l.onStartAsync(event), this.listeners::clear);
        return this;
    }

    public void onError(Throwable throwable) {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, (ServletResponse)this.response, throwable);
        this.executeOnListeners(l -> l.onError(event), null);
        if (!this.response.isCommitted() && HttpServletResponse.class.isInstance(this.response)) {
            HttpServletResponse http = (HttpServletResponse)HttpServletResponse.class.cast(this.response);
            http.setStatus(500);
        }
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOnListeners(UnsafeConsumer<AsyncListener> fn, Runnable afterCopy) {
        ArrayList listenersCopy;
        Collection<AsyncListener> collection = this.listeners;
        synchronized (collection) {
            listenersCopy = new ArrayList(this.listeners.size());
            Optional.ofNullable(afterCopy).ifPresent(Runnable::run);
        }
        listenersCopy.forEach(listener -> {
            try {
                fn.accept((AsyncListener)listener);
            }
            catch (Throwable t) {
                log.warn("callback failed for listener of type [" + listener.getClass().getName() + "]", t);
            }
        });
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.originalRequestAndResponse;
    }

    public void dispatch() {
        ServletRequest servletRequest = this.getRequest();
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new IllegalStateException("Not a http request: " + servletRequest);
        }
        HttpServletRequest sr = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        String path = sr.getRequestURI();
        String cpath = sr.getContextPath();
        if (cpath.length() > 1) {
            path = path.substring(cpath.length());
        }
        this.dispatch(AsyncContextImpl.urlDecode(path));
    }

    public void dispatch(String path) {
        this.dispatch(this.request.getServletContext(), path);
    }

    public void dispatch(ServletContext context, String path) {
        ServletRequest servletRequest = this.getRequest();
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new IllegalStateException("Not a http request: " + servletRequest);
        }
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        if (request.getAttribute("javax.servlet.async.request_uri") == null) {
            request.setAttribute("javax.servlet.async.request_uri", (Object)request.getRequestURI());
            request.setAttribute("javax.servlet.async.context_path", (Object)request.getContextPath());
            request.setAttribute("javax.servlet.async.servlet_path", (Object)request.getServletPath());
            request.setAttribute("javax.servlet.async.path_info", (Object)request.getPathInfo());
            request.setAttribute("javax.servlet.async.query_string", (Object)request.getQueryString());
        }
        try {
            this.controller.invoke(request, (HttpServletResponse)this.response);
        }
        catch (ServletException ioe) {
            this.onError(ioe);
        }
    }

    public void complete() {
        AsyncEvent event = new AsyncEvent((AsyncContext)this, this.request, (ServletResponse)this.response);
        this.executeOnListeners(l -> l.onComplete(event), null);
        try {
            this.response.getOutputStream().close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void start(Runnable run) {
        run.run();
    }

    public void addListener(AsyncListener listener) {
        this.listeners.add(new AsyncListenerWrapper(listener, this.request, (ServletResponse)this.response));
    }

    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        this.listeners.add(new AsyncListenerWrapper(listener, request, response));
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) {
        return (T)((AsyncListener)CDI.current().select(clazz, new Annotation[0]).get());
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private static String urlDecode(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(37) == -1) {
            return str;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(str.length() * 2);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        char[] sourceChars = str.toCharArray();
        int len = sourceChars.length;
        int ix = 0;
        try {
            while (ix < len) {
                char c;
                if ((c = sourceChars[ix++]) == '%') {
                    osw.flush();
                    if (ix + 2 > len) {
                        throw new IllegalArgumentException("Missing digit: " + str);
                    }
                    char c1 = sourceChars[ix++];
                    char c2 = sourceChars[ix++];
                    if (AsyncContextImpl.isHexDigit(c1) && AsyncContextImpl.isHexDigit(c2)) {
                        baos.write(AsyncContextImpl.x2c(c1, c2));
                        continue;
                    }
                    throw new IllegalArgumentException("Missing digit: " + str);
                }
                osw.append(c);
            }
            osw.flush();
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    private static boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static int x2c(char b1, char b2) {
        int digit = b1 >= 'A' ? (b1 & 0xDF) - 65 + 10 : b1 - 48;
        digit *= 16;
        return digit += b2 >= 'A' ? (b2 & 0xDF) - 65 + 10 : b2 - 48;
    }

    @Generated
    public AsyncContextImpl(ServletRequest request, InMemoryResponse response, boolean originalRequestAndResponse, ServletController controller) {
        this.request = request;
        this.response = response;
        this.originalRequestAndResponse = originalRequestAndResponse;
        this.controller = controller;
    }

    @FunctionalInterface
    private static interface UnsafeConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    private static class AsyncListenerWrapper
    implements AsyncListener {
        private final AsyncListener delegate;
        private final ServletRequest request;
        private final ServletResponse response;

        private AsyncListenerWrapper(AsyncListener delegate, ServletRequest request, ServletResponse response) {
            this.delegate = delegate;
            this.request = request;
            this.response = response;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            this.delegate.onComplete(this.wrap(event));
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.delegate.onTimeout(this.wrap(event));
        }

        public void onError(AsyncEvent event) throws IOException {
            this.delegate.onError(this.wrap(event));
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this.delegate.onStartAsync(this.wrap(event));
        }

        private AsyncEvent wrap(AsyncEvent event) {
            if (this.request != null && this.response != null) {
                return new AsyncEvent(event.getAsyncContext(), this.request, this.response, event.getThrowable());
            }
            return event;
        }
    }
}

