/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class InMemoryResponse
implements HttpServletResponse {
    private final BooleanSupplier isOpen;
    private final Runnable onFlush;
    private final Consumer<byte[]> writeCallback;
    private final BiFunction<Integer, Map<String, List<String>>, String> preWrite;
    private int code = 200;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private transient PrintWriter writer;
    private transient ServletByteArrayOutputStream sosi;
    private boolean commited = false;
    private String encoding = "UTF-8";
    private Locale locale = Locale.getDefault();

    public InMemoryResponse(BooleanSupplier isOpen, Runnable onFlush, Consumer<byte[]> write, BiFunction<Integer, Map<String, List<String>>, String> preWrite) {
        this.isOpen = isOpen;
        this.onFlush = onFlush;
        this.writeCallback = write;
        this.preWrite = preWrite;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, new ArrayList<String>(Collections.singletonList(value)));
    }

    public void setIntHeader(String s, int i) {
        this.setHeader(s, Integer.toString(i));
    }

    public void setStatus(int i) {
        this.setCode(i);
    }

    public void setStatus(int i, String s) {
        this.setCode(i);
    }

    public void addCookie(Cookie cookie) {
        this.setHeader(cookie.getName(), cookie.getValue());
    }

    public void addDateHeader(String s, long l) {
        this.setHeader(s, Long.toString(l));
    }

    public void addHeader(String s, String s1) {
        Collection list = this.headers.get(s);
        if (list == null) {
            this.setHeader(s, s1);
        } else {
            list.add(s1);
        }
    }

    public void addIntHeader(String s, int i) {
        this.setIntHeader(s, i);
    }

    public boolean containsHeader(String s) {
        return this.headers.containsKey(s);
    }

    public String encodeURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectURL(String s) {
        return this.toEncoded(s);
    }

    public String encodeUrl(String s) {
        return this.toEncoded(s);
    }

    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public String getHeader(String name) {
        Collection strings = this.headers.get(name);
        return strings == null ? null : (String)strings.iterator().next();
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String s) {
        return this.headers.get(s);
    }

    public int getStatus() {
        return this.getCode();
    }

    public void sendError(int i) throws IOException {
        this.setCode(i);
    }

    public void sendError(int i, String s) throws IOException {
        this.setCode(i);
    }

    public void sendRedirect(String path) throws IOException {
        if (this.commited) {
            throw new IllegalStateException("response already committed");
        }
        this.resetBuffer();
        try {
            this.setStatus(302);
            this.setHeader("Location", this.toEncoded(path));
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
    }

    public void setDateHeader(String s, long l) {
        this.addDateHeader(s, l);
    }

    public ServletOutputStream getOutputStream() {
        return this.sosi == null ? (this.sosi = this.createOutputStream()) : this.sosi;
    }

    public PrintWriter getWriter() {
        return this.writer == null ? (this.writer = new PrintWriter((OutputStream)this.getOutputStream())) : this.writer;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public void reset() {
        this.createOutputStream();
    }

    private ServletByteArrayOutputStream createOutputStream() {
        this.sosi = new ServletByteArrayOutputStream(this.isOpen, this.onFlush, this.writeCallback, () -> this.preWrite.apply(this.getStatus(), this.headers)){

            @Override
            protected void beforeClose() throws IOException {
                InMemoryResponse.this.onClose((OutputStream)((Object)this));
            }
        };
        return this.sosi;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public int getBufferSize() {
        return this.sosi.outputStream.size();
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setCode(int code) {
        this.code = code;
        this.commited = true;
    }

    public int getCode() {
        return this.code;
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void resetBuffer() {
        this.sosi.outputStream.reset();
    }

    public void setBufferSize(int i) {
    }

    public void setCharacterEncoding(String s) {
        this.encoding = s;
    }

    public void setContentLength(int i) {
    }

    public void setContentLengthLong(long length) {
    }

    private String toEncoded(String url) {
        return url;
    }

    protected void onClose(OutputStream stream) throws IOException {
    }

    private static class ServletByteArrayOutputStream
    extends ServletOutputStream {
        private static final int BUFFER_SIZE = 8192;
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private final BooleanSupplier isOpen;
        private final Runnable onFlush;
        private final Consumer<byte[]> writer;
        private final Supplier<String> preWrite;
        private boolean closed;
        private boolean headerWritten;

        private ServletByteArrayOutputStream(BooleanSupplier isOpen, Runnable onFlush, Consumer<byte[]> write, Supplier<String> preWrite) {
            this.isOpen = isOpen;
            this.onFlush = onFlush;
            this.writer = write;
            this.preWrite = preWrite;
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener listener) {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) {
            this.outputStream.write(b, off, len);
        }

        public void writeTo(OutputStream out) throws IOException {
            this.outputStream.writeTo(out);
        }

        public void reset() {
            this.outputStream.reset();
        }

        public void flush() throws IOException {
            if (!this.isOpen.getAsBoolean()) {
                return;
            }
            if (this.outputStream.size() >= 8192) {
                this.doFlush();
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.beforeClose();
            this.doFlush();
            this.closed = true;
        }

        protected void beforeClose() throws IOException {
        }

        private void doFlush() {
            boolean written;
            byte[] array = this.outputStream.toByteArray();
            boolean bl = written = array.length > 0 || !this.headerWritten;
            if (!this.headerWritten) {
                String headers = this.preWrite.get();
                if (!headers.isEmpty()) {
                    this.writer.accept(headers.getBytes(StandardCharsets.UTF_8));
                }
                this.headerWritten = true;
            }
            if (array.length > 0) {
                this.outputStream.reset();
                this.writer.accept(array);
            }
            if (written) {
                this.onFlush.run();
            }
        }
    }
}

