/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.json.bind.Jsonb;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.internationalization.ParameterBundle;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.util.DefaultValueInspector;
import org.talend.sdk.component.server.configuration.ComponentServerConfiguration;
import org.talend.sdk.component.server.front.model.PropertyValidation;
import org.talend.sdk.component.server.front.model.SimplePropertyDefinition;
import org.talend.sdk.component.server.lang.CustomCollectors;
import org.talend.sdk.component.server.service.PropertyValidationService;
import org.talend.sdk.component.server.service.qualifier.ComponentServer;

@ApplicationScoped
public class PropertiesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertiesService.class);
    private final DefaultValueInspector defaultValueInspector = new DefaultValueInspector();
    @Inject
    private PropertyValidationService propertyValidationService;
    @Inject
    private ComponentServerConfiguration componentServerConfiguration;
    @Inject
    @ComponentServer
    private Jsonb defaultMapper;

    public Stream<SimplePropertyDefinition> buildProperties(List<ParameterMeta> meta, ClassLoader loader, Locale locale, DefaultValueInspector.Instance rootInstance) {
        return this.buildProperties(meta, loader, locale, rootInstance, null);
    }

    private Stream<SimplePropertyDefinition> buildProperties(List<ParameterMeta> meta, ClassLoader loader, Locale locale, DefaultValueInspector.Instance rootInstance, ParameterMeta parent) {
        return meta.stream().flatMap(p -> {
            Map metadata;
            String path = this.sanitizePropertyName(p.getPath());
            String name = this.sanitizePropertyName(p.getName());
            String type = p.getType().name();
            boolean isEnum = p.getType() == ParameterMeta.Type.ENUM;
            PropertyValidation validation = this.propertyValidationService.map(p.getMetadata());
            if (isEnum) {
                if (validation == null) {
                    validation = new PropertyValidation();
                }
                validation.setEnumValues(p.getProposals());
            }
            Map sanitizedMetadata = Optional.ofNullable(p.getMetadata()).map(m -> m.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("tcomp::validation::")).collect(CustomCollectors.toLinkedMap(e -> ((String)e.getKey()).replace("tcomp::", ""), Map.Entry::getValue))).orElse(null);
            if (parent != null) {
                metadata = sanitizedMetadata;
            } else {
                metadata = Optional.ofNullable(sanitizedMetadata).orElseGet(HashMap::new);
                metadata.put("definition::parameter::index", String.valueOf(meta.indexOf(p)));
            }
            DefaultValueInspector.Instance instance = this.defaultValueInspector.createDemoInstance(Optional.ofNullable(rootInstance).map(DefaultValueInspector.Instance::getValue).orElse(null), p);
            ParameterBundle bundle = p.findBundle(loader, locale);
            ParameterBundle parentBundle = parent == null ? null : parent.findBundle(loader, locale);
            return Stream.concat(Stream.of(new SimplePropertyDefinition(path, name, bundle.displayName(parentBundle).orElse(p.getName()), type, this.toDefault(instance, (ParameterMeta)p), validation, this.rewriteMetadataForLocale(metadata, parentBundle, bundle), bundle.placeholder(parentBundle).orElse(p.getName()), !isEnum ? null : p.getProposals().stream().collect(CustomCollectors.toLinkedMap(Function.identity(), key -> bundle.enumDisplayName(parentBundle, key).orElse(key))))), this.buildProperties(p.getNestedParameters(), loader, locale, instance, (ParameterMeta)p));
        }).sorted(Comparator.comparing(SimplePropertyDefinition::getPath));
    }

    private Map<String, String> rewriteMetadataForLocale(Map<String, String> metadata, ParameterBundle parentBundle, ParameterBundle bundle) {
        return this.rewriteLayoutMetadata(this.rewriteDocMetadata(metadata, parentBundle, bundle), parentBundle, bundle);
    }

    private Map<String, String> rewriteDocMetadata(Map<String, String> metadata, ParameterBundle parentBundle, ParameterBundle bundle) {
        String defaultDoc = metadata.get("documentation::value");
        String bundleDoc = bundle.documentation(parentBundle).orElse(null);
        if (bundleDoc == null || bundleDoc.equals(defaultDoc)) {
            return metadata;
        }
        HashMap<String, String> copy = new HashMap<String, String>(metadata);
        copy.put("documentation::value", bundleDoc);
        return copy;
    }

    private Map<String, String> rewriteLayoutMetadata(Map<String, String> metadata, ParameterBundle parentBundle, ParameterBundle bundle) {
        if (!this.componentServerConfiguration.getTranslateGridLayoutTabNames().booleanValue()) {
            return metadata;
        }
        Collection keysToRewrite = metadata.keySet().stream().filter(it -> it.startsWith("ui::gridlayout::") && it.endsWith("::value")).collect(Collectors.toSet());
        if (keysToRewrite.isEmpty()) {
            return metadata;
        }
        Predicate<Map.Entry> shouldBeRewritten = k -> keysToRewrite.contains(k.getKey());
        return Stream.concat(metadata.entrySet().stream().filter(shouldBeRewritten.negate()), metadata.entrySet().stream().filter(shouldBeRewritten).map(it -> new AbstractMap.SimpleEntry<String, String>(bundle.gridLayoutName(parentBundle, ((String)it.getKey()).substring("ui::gridlayout::".length(), ((String)it.getKey()).length() - "::value".length())).map(t -> "ui::gridlayout::" + t + "::value").orElse((String)it.getKey()), (String)it.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private String toDefault(DefaultValueInspector.Instance instance, ParameterMeta p) {
        if (instance.isCreated()) {
            return null;
        }
        if (Collection.class.isInstance(instance.getValue()) || Map.class.isInstance(instance.getValue())) {
            return this.defaultMapper.toJson(instance.getValue());
        }
        return this.defaultValueInspector.findDefault(instance.getValue(), p);
    }

    private String sanitizePropertyName(String path) {
        return path.replace("${index}", "");
    }
}

