/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.talend.sdk.component.server.front.model.PropertyValidation;

@ApplicationScoped
public class PropertyValidationService {
    private Function<Map<String, String>, PropertyValidation> propertyValidationCreator;

    @PostConstruct
    private void initMapper() {
        Collection validationSetters = Stream.of(PropertyValidation.class.getDeclaredFields()).map((? super T f) -> {
            Function<String, Object> valueConverter = Integer.class == f.getType() ? v -> Double.valueOf(v).intValue() : (Boolean.class == f.getType() ? Boolean::parseBoolean : (Collection.class == f.getType() ? s -> Stream.of(s.split(",")).collect(Collectors.toList()) : s -> s));
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return (instance, meta) -> Optional.ofNullable((String)meta.get("tcomp::validation::" + f.getName())).map(valueConverter).map((? super T val) -> {
                try {
                    f.set(instance, val);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                return true;
            }).orElse(false);
        }).collect(Collectors.toList());
        this.propertyValidationCreator = config -> {
            PropertyValidation validation = new PropertyValidation();
            if (validationSetters.stream().filter(s -> (Boolean)s.apply(validation, config)).count() == 0L) {
                return null;
            }
            return validation;
        };
    }

    public PropertyValidation map(Map<String, String> meta) {
        return this.propertyValidationCreator.apply(meta);
    }
}

