/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Vetoed
public class ScmConfigurationLoader
implements ConfigSource {
    private final Map<String, String> map = new HashMap<String, String>();
    private volatile boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInit() {
        if (this.init) {
            return;
        }
        ScmConfigurationLoader scmConfigurationLoader = this;
        synchronized (scmConfigurationLoader) {
            if (this.init) {
                return;
            }
            try (final InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("TALEND-INF/git.properties");){
                Properties properties = new Properties(){
                    {
                        try {
                            this.load(stream);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                };
                properties.stringPropertyNames().stream().collect(() -> this.map, (m, k) -> m.put(k, properties.getProperty((String)k)), Map::putAll);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.init = true;
        }
    }

    public Map<String, String> getProperties() {
        this.ensureInit();
        return this.map;
    }

    public Set<String> getPropertyNames() {
        this.ensureInit();
        return this.map.keySet();
    }

    public int getOrdinal() {
        return 1000;
    }

    public String getValue(String propertyName) {
        this.ensureInit();
        return this.map.get(propertyName);
    }

    public String getName() {
        return "component-scm-configuration";
    }
}

