/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.pubsub;

import java.util.ArrayDeque;
import java.util.Deque;
import zmq.Ctx;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.pubsub.Dist;
import zmq.socket.pubsub.Mtrie;
import zmq.util.Blob;

public class XPub
extends SocketBase {
    private final Mtrie subscriptions;
    private final Dist dist;
    private boolean verbose;
    private boolean more;
    private boolean lossy;
    private final Deque<Blob> pendingData;
    private final Deque<Integer> pendingFlags;
    private static final Mtrie.IMtrieHandler markAsMatching = new MarkAsMatching();
    private static final Mtrie.IMtrieHandler sendUnsubscription = new SendUnsubscription();

    public XPub(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 9;
        this.verbose = false;
        this.more = false;
        this.lossy = true;
        this.subscriptions = new Mtrie();
        this.dist = new Dist();
        this.pendingData = new ArrayDeque<Blob>();
        this.pendingFlags = new ArrayDeque<Integer>();
    }

    @Override
    protected void xattachPipe(Pipe pipe, boolean subscribeToAll) {
        assert (pipe != null);
        this.dist.attach(pipe);
        if (subscribeToAll) {
            this.subscriptions.add(null, pipe);
        }
        this.xreadActivated(pipe);
    }

    @Override
    protected void xreadActivated(Pipe pipe) {
        Msg sub = null;
        while ((sub = pipe.read()) != null) {
            byte[] data = sub.data();
            int size = sub.size();
            if (size > 0 && (data[0] == 0 || data[0] == 1)) {
                boolean unique = data[0] == 0 ? this.subscriptions.rm(data, size, pipe) : this.subscriptions.add(data, size, pipe);
                if (this.options.type != 9 || !unique && (data[0] <= 0 || !this.verbose)) continue;
                this.pendingData.add(Blob.createBlob(sub));
                this.pendingFlags.add(0);
                continue;
            }
            this.pendingData.add(Blob.createBlob(sub));
            this.pendingFlags.add(sub.flags());
        }
    }

    @Override
    protected void xwriteActivated(Pipe pipe) {
        this.dist.activated(pipe);
    }

    @Override
    public boolean xsetsockopt(int option, Object optval) {
        if (option == 40) {
            this.verbose = Options.parseBoolean(option, optval);
        } else if (option == 69) {
            this.lossy = !Options.parseBoolean(option, optval);
        } else {
            this.errno.set(22);
            return false;
        }
        return true;
    }

    @Override
    protected void xpipeTerminated(Pipe pipe) {
        this.subscriptions.rm(pipe, sendUnsubscription, this);
        this.dist.terminated(pipe);
    }

    private void markAsMatching(Pipe pipe) {
        this.dist.match(pipe);
    }

    @Override
    protected boolean xsend(Msg msg) {
        boolean msgMore = msg.hasMore();
        if (!this.more) {
            this.subscriptions.match(msg.buf(), msg.size(), markAsMatching, this);
        }
        if (this.lossy || this.dist.checkHwm()) {
            if (this.dist.sendToMatching(msg)) {
                if (!msgMore) {
                    this.dist.unmatch();
                }
                this.more = msgMore;
                return true;
            }
        } else {
            this.errno.set(35);
        }
        return false;
    }

    @Override
    protected boolean xhasOut() {
        return this.dist.hasOut();
    }

    @Override
    protected Msg xrecv() {
        if (this.pendingData.isEmpty()) {
            this.errno.set(35);
            return null;
        }
        Blob first = this.pendingData.pollFirst();
        Msg msg = new Msg(first.data());
        int flags = this.pendingFlags.pollFirst();
        msg.setFlags(flags);
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return !this.pendingData.isEmpty();
    }

    private void sendUnsubscription(byte[] data, int size) {
        if (this.options.type != 1) {
            byte[] unsub = new byte[size + 1];
            unsub[0] = 0;
            System.arraycopy(data, 0, unsub, 1, size);
            this.pendingData.add(Blob.createBlob(unsub));
            this.pendingFlags.add(0);
        }
    }

    private static final class MarkAsMatching
    implements Mtrie.IMtrieHandler {
        private MarkAsMatching() {
        }

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, XPub self) {
            self.markAsMatching(pipe);
        }
    }

    private static final class SendUnsubscription
    implements Mtrie.IMtrieHandler {
        private SendUnsubscription() {
        }

        @Override
        public void invoke(Pipe pipe, byte[] data, int size, XPub self) {
            self.sendUnsubscription(data, size);
        }
    }
}

