/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.reqrep;

import zmq.Ctx;
import zmq.Msg;
import zmq.socket.reqrep.Router;

public class Rep
extends Router {
    private boolean sendingReply = false;
    private boolean requestBegins = true;

    public Rep(Ctx parent, int tid, int sid) {
        super(parent, tid, sid);
        this.options.type = 4;
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (!this.sendingReply) {
            this.errno.set(156384763);
            return false;
        }
        boolean more = msg.hasMore();
        boolean rc = super.xsend(msg);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.sendingReply = false;
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (this.sendingReply) {
            this.errno.set(156384763);
        }
        Msg msg = null;
        if (this.requestBegins) {
            while (true) {
                if ((msg = super.xrecv()) == null) {
                    return null;
                }
                if (msg.hasMore()) {
                    boolean bottom = msg.size() == 0;
                    boolean rc = super.xsend(msg);
                    assert (rc);
                    if (!bottom) continue;
                    break;
                }
                super.rollback();
            }
            this.requestBegins = false;
        }
        if ((msg = super.xrecv()) == null) {
            return null;
        }
        if (!msg.hasMore()) {
            this.sendingReply = true;
            this.requestBegins = true;
        }
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return !this.sendingReply && super.xhasIn();
    }

    @Override
    protected boolean xhasOut() {
        return this.sendingReply && super.xhasOut();
    }
}

