/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.DistillationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomizationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomizationConfig> {
    private static final SdkField<DistillationConfig> DISTILLATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distillationConfig").getter(CustomizationConfig.getter(CustomizationConfig::distillationConfig)).setter(CustomizationConfig.setter(Builder::distillationConfig)).constructor(DistillationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distillationConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISTILLATION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomizationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DistillationConfig distillationConfig;
    private final Type type;

    private CustomizationConfig(BuilderImpl builder) {
        this.distillationConfig = builder.distillationConfig;
        this.type = builder.type;
    }

    public final DistillationConfig distillationConfig() {
        return this.distillationConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.distillationConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomizationConfig)) {
            return false;
        }
        CustomizationConfig other = (CustomizationConfig)obj;
        return Objects.equals(this.distillationConfig(), other.distillationConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CustomizationConfig").add("DistillationConfig", (Object)this.distillationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "distillationConfig": {
                return Optional.ofNullable(clazz.cast(this.distillationConfig()));
            }
        }
        return Optional.empty();
    }

    public static CustomizationConfig fromDistillationConfig(DistillationConfig distillationConfig) {
        return (CustomizationConfig)CustomizationConfig.builder().distillationConfig(distillationConfig).build();
    }

    public static CustomizationConfig fromDistillationConfig(Consumer<DistillationConfig.Builder> distillationConfig) {
        DistillationConfig.Builder builder = DistillationConfig.builder();
        distillationConfig.accept(builder);
        return CustomizationConfig.fromDistillationConfig((DistillationConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DistillationConfig>> map = new HashMap<String, SdkField<DistillationConfig>>();
        map.put("distillationConfig", DISTILLATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomizationConfig, T> g) {
        return obj -> g.apply((CustomizationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DISTILLATION_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DistillationConfig distillationConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomizationConfig model) {
            this.distillationConfig(model.distillationConfig);
        }

        public final DistillationConfig.Builder getDistillationConfig() {
            return this.distillationConfig != null ? this.distillationConfig.toBuilder() : null;
        }

        public final void setDistillationConfig(DistillationConfig.BuilderImpl distillationConfig) {
            DistillationConfig oldValue = this.distillationConfig;
            this.distillationConfig = distillationConfig != null ? distillationConfig.build() : null;
            this.handleUnionValueChange(Type.DISTILLATION_CONFIG, oldValue, this.distillationConfig);
        }

        @Override
        public final Builder distillationConfig(DistillationConfig distillationConfig) {
            DistillationConfig oldValue = this.distillationConfig;
            this.distillationConfig = distillationConfig;
            this.handleUnionValueChange(Type.DISTILLATION_CONFIG, oldValue, this.distillationConfig);
            return this;
        }

        public CustomizationConfig build() {
            return new CustomizationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomizationConfig> {
        public Builder distillationConfig(DistillationConfig var1);

        default public Builder distillationConfig(Consumer<DistillationConfig.Builder> distillationConfig) {
            return this.distillationConfig((DistillationConfig)((DistillationConfig.Builder)DistillationConfig.builder().applyMutation(distillationConfig)).build());
        }
    }
}

