/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType;
import software.amazon.awssdk.services.bedrock.model.GuardrailWordAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailManagedWords
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailManagedWords> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailManagedWords.getter(GuardrailManagedWords::typeAsString)).setter(GuardrailManagedWords.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputAction").getter(GuardrailManagedWords.getter(GuardrailManagedWords::inputActionAsString)).setter(GuardrailManagedWords.setter(Builder::inputAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()}).build();
    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputAction").getter(GuardrailManagedWords.getter(GuardrailManagedWords::outputActionAsString)).setter(GuardrailManagedWords.setter(Builder::outputAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()}).build();
    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("inputEnabled").getter(GuardrailManagedWords.getter(GuardrailManagedWords::inputEnabled)).setter(GuardrailManagedWords.setter(Builder::inputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()}).build();
    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("outputEnabled").getter(GuardrailManagedWords.getter(GuardrailManagedWords::outputEnabled)).setter(GuardrailManagedWords.setter(Builder::outputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailManagedWords.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String inputAction;
    private final String outputAction;
    private final Boolean inputEnabled;
    private final Boolean outputEnabled;

    private GuardrailManagedWords(BuilderImpl builder) {
        this.type = builder.type;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    public final GuardrailManagedWordsType type() {
        return GuardrailManagedWordsType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final GuardrailWordAction inputAction() {
        return GuardrailWordAction.fromValue(this.inputAction);
    }

    public final String inputActionAsString() {
        return this.inputAction;
    }

    public final GuardrailWordAction outputAction() {
        return GuardrailWordAction.fromValue(this.outputAction);
    }

    public final String outputActionAsString() {
        return this.outputAction;
    }

    public final Boolean inputEnabled() {
        return this.inputEnabled;
    }

    public final Boolean outputEnabled() {
        return this.outputEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailManagedWords)) {
            return false;
        }
        GuardrailManagedWords other = (GuardrailManagedWords)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.inputActionAsString(), other.inputActionAsString()) && Objects.equals(this.outputActionAsString(), other.outputActionAsString()) && Objects.equals(this.inputEnabled(), other.inputEnabled()) && Objects.equals(this.outputEnabled(), other.outputEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailManagedWords").add("Type", (Object)this.typeAsString()).add("InputAction", (Object)(this.inputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputAction", (Object)(this.outputActionAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("InputEnabled", (Object)this.inputEnabled()).add("OutputEnabled", (Object)this.outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "inputAction": {
                return Optional.ofNullable(clazz.cast(this.inputActionAsString()));
            }
            case "outputAction": {
                return Optional.ofNullable(clazz.cast(this.outputActionAsString()));
            }
            case "inputEnabled": {
                return Optional.ofNullable(clazz.cast(this.inputEnabled()));
            }
            case "outputEnabled": {
                return Optional.ofNullable(clazz.cast(this.outputEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailManagedWords, T> g) {
        return obj -> g.apply((GuardrailManagedWords)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String inputAction;
        private String outputAction;
        private Boolean inputEnabled;
        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailManagedWords model) {
            this.type(model.type);
            this.inputAction(model.inputAction);
            this.outputAction(model.outputAction);
            this.inputEnabled(model.inputEnabled);
            this.outputEnabled(model.outputEnabled);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailManagedWordsType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInputAction() {
            return this.inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailWordAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return this.outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailWordAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return this.inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return this.outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        public GuardrailManagedWords build() {
            return new GuardrailManagedWords(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailManagedWords> {
        public Builder type(String var1);

        public Builder type(GuardrailManagedWordsType var1);

        public Builder inputAction(String var1);

        public Builder inputAction(GuardrailWordAction var1);

        public Builder outputAction(String var1);

        public Builder outputAction(GuardrailWordAction var1);

        public Builder inputEnabled(Boolean var1);

        public Builder outputEnabled(Boolean var1);
    }
}

