/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailPiiEntityFilter;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailPiiEntityFilterListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailRegexFilter;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailRegexFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailSensitiveInformationPolicyAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailSensitiveInformationPolicyAssessment> {
    private static final SdkField<List<GuardrailPiiEntityFilter>> PII_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("piiEntities").getter(GuardrailSensitiveInformationPolicyAssessment.getter(GuardrailSensitiveInformationPolicyAssessment::piiEntities)).setter(GuardrailSensitiveInformationPolicyAssessment.setter(Builder::piiEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("piiEntities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailPiiEntityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailRegexFilter>> REGEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regexes").getter(GuardrailSensitiveInformationPolicyAssessment.getter(GuardrailSensitiveInformationPolicyAssessment::regexes)).setter(GuardrailSensitiveInformationPolicyAssessment.setter(Builder::regexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailRegexFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PII_ENTITIES_FIELD, REGEXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailSensitiveInformationPolicyAssessment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailPiiEntityFilter> piiEntities;
    private final List<GuardrailRegexFilter> regexes;

    private GuardrailSensitiveInformationPolicyAssessment(BuilderImpl builder) {
        this.piiEntities = builder.piiEntities;
        this.regexes = builder.regexes;
    }

    public final boolean hasPiiEntities() {
        return this.piiEntities != null && !(this.piiEntities instanceof SdkAutoConstructList);
    }

    public final List<GuardrailPiiEntityFilter> piiEntities() {
        return this.piiEntities;
    }

    public final boolean hasRegexes() {
        return this.regexes != null && !(this.regexes instanceof SdkAutoConstructList);
    }

    public final List<GuardrailRegexFilter> regexes() {
        return this.regexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPiiEntities() ? this.piiEntities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegexes() ? this.regexes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailSensitiveInformationPolicyAssessment)) {
            return false;
        }
        GuardrailSensitiveInformationPolicyAssessment other = (GuardrailSensitiveInformationPolicyAssessment)obj;
        return this.hasPiiEntities() == other.hasPiiEntities() && Objects.equals(this.piiEntities(), other.piiEntities()) && this.hasRegexes() == other.hasRegexes() && Objects.equals(this.regexes(), other.regexes());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailSensitiveInformationPolicyAssessment").add("PiiEntities", this.hasPiiEntities() ? this.piiEntities() : null).add("Regexes", this.hasRegexes() ? this.regexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "piiEntities": {
                return Optional.ofNullable(clazz.cast(this.piiEntities()));
            }
            case "regexes": {
                return Optional.ofNullable(clazz.cast(this.regexes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("piiEntities", PII_ENTITIES_FIELD);
        map.put("regexes", REGEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailSensitiveInformationPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailSensitiveInformationPolicyAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailPiiEntityFilter> piiEntities = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailRegexFilter> regexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailSensitiveInformationPolicyAssessment model) {
            this.piiEntities(model.piiEntities);
            this.regexes(model.regexes);
        }

        public final List<GuardrailPiiEntityFilter.Builder> getPiiEntities() {
            List<GuardrailPiiEntityFilter.Builder> result = GuardrailPiiEntityFilterListCopier.copyToBuilder(this.piiEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPiiEntities(Collection<GuardrailPiiEntityFilter.BuilderImpl> piiEntities) {
            this.piiEntities = GuardrailPiiEntityFilterListCopier.copyFromBuilder(piiEntities);
        }

        @Override
        public final Builder piiEntities(Collection<GuardrailPiiEntityFilter> piiEntities) {
            this.piiEntities = GuardrailPiiEntityFilterListCopier.copy(piiEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(GuardrailPiiEntityFilter ... piiEntities) {
            this.piiEntities(Arrays.asList(piiEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder piiEntities(Consumer<GuardrailPiiEntityFilter.Builder> ... piiEntities) {
            this.piiEntities(Stream.of(piiEntities).map(c -> (GuardrailPiiEntityFilter)((GuardrailPiiEntityFilter.Builder)GuardrailPiiEntityFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailRegexFilter.Builder> getRegexes() {
            List<GuardrailRegexFilter.Builder> result = GuardrailRegexFilterListCopier.copyToBuilder(this.regexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegexes(Collection<GuardrailRegexFilter.BuilderImpl> regexes) {
            this.regexes = GuardrailRegexFilterListCopier.copyFromBuilder(regexes);
        }

        @Override
        public final Builder regexes(Collection<GuardrailRegexFilter> regexes) {
            this.regexes = GuardrailRegexFilterListCopier.copy(regexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(GuardrailRegexFilter ... regexes) {
            this.regexes(Arrays.asList(regexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexes(Consumer<GuardrailRegexFilter.Builder> ... regexes) {
            this.regexes(Stream.of(regexes).map(c -> (GuardrailRegexFilter)((GuardrailRegexFilter.Builder)GuardrailRegexFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailSensitiveInformationPolicyAssessment build() {
            return new GuardrailSensitiveInformationPolicyAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailSensitiveInformationPolicyAssessment> {
        public Builder piiEntities(Collection<GuardrailPiiEntityFilter> var1);

        public Builder piiEntities(GuardrailPiiEntityFilter ... var1);

        public Builder piiEntities(Consumer<GuardrailPiiEntityFilter.Builder> ... var1);

        public Builder regexes(Collection<GuardrailRegexFilter> var1);

        public Builder regexes(GuardrailRegexFilter ... var1);

        public Builder regexes(Consumer<GuardrailRegexFilter.Builder> ... var1);
    }
}

