/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTypeConfig.getter(InstanceTypeConfig::instanceType)).setter(InstanceTypeConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WeightedCapacity").getter(InstanceTypeConfig.getter(InstanceTypeConfig::weightedCapacity)).setter(InstanceTypeConfig.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()}).build();
    private static final SdkField<String> BID_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BidPrice").getter(InstanceTypeConfig.getter(InstanceTypeConfig::bidPrice)).setter(InstanceTypeConfig.setter(Builder::bidPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPrice").build()}).build();
    private static final SdkField<Double> BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BidPriceAsPercentageOfOnDemandPrice").getter(InstanceTypeConfig.getter(InstanceTypeConfig::bidPriceAsPercentageOfOnDemandPrice)).setter(InstanceTypeConfig.setter(Builder::bidPriceAsPercentageOfOnDemandPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPriceAsPercentageOfOnDemandPrice").build()}).build();
    private static final SdkField<EbsConfiguration> EBS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsConfiguration").getter(InstanceTypeConfig.getter(InstanceTypeConfig::ebsConfiguration)).setter(InstanceTypeConfig.setter(Builder::ebsConfiguration)).constructor(EbsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsConfiguration").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configurations").getter(InstanceTypeConfig.getter(InstanceTypeConfig::configurations)).setter(InstanceTypeConfig.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOM_AMI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAmiId").getter(InstanceTypeConfig.getter(InstanceTypeConfig::customAmiId)).setter(InstanceTypeConfig.setter(Builder::customAmiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAmiId").build()}).build();
    private static final SdkField<Double> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Priority").getter(InstanceTypeConfig.getter(InstanceTypeConfig::priority)).setter(InstanceTypeConfig.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, WEIGHTED_CAPACITY_FIELD, BID_PRICE_FIELD, BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD, EBS_CONFIGURATION_FIELD, CONFIGURATIONS_FIELD, CUSTOM_AMI_ID_FIELD, PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceTypeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer weightedCapacity;
    private final String bidPrice;
    private final Double bidPriceAsPercentageOfOnDemandPrice;
    private final EbsConfiguration ebsConfiguration;
    private final List<Configuration> configurations;
    private final String customAmiId;
    private final Double priority;

    private InstanceTypeConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.bidPrice = builder.bidPrice;
        this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.configurations = builder.configurations;
        this.customAmiId = builder.customAmiId;
        this.priority = builder.priority;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer weightedCapacity() {
        return this.weightedCapacity;
    }

    public final String bidPrice() {
        return this.bidPrice;
    }

    public final Double bidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public final EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<Configuration> configurations() {
        return this.configurations;
    }

    public final String customAmiId() {
        return this.customAmiId;
    }

    public final Double priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPriceAsPercentageOfOnDemandPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customAmiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeConfig)) {
            return false;
        }
        InstanceTypeConfig other = (InstanceTypeConfig)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.bidPriceAsPercentageOfOnDemandPrice(), other.bidPriceAsPercentageOfOnDemandPrice()) && Objects.equals(this.ebsConfiguration(), other.ebsConfiguration()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.customAmiId(), other.customAmiId()) && Objects.equals(this.priority(), other.priority());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTypeConfig").add("InstanceType", (Object)this.instanceType()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("BidPrice", (Object)this.bidPrice()).add("BidPriceAsPercentageOfOnDemandPrice", (Object)this.bidPriceAsPercentageOfOnDemandPrice()).add("EbsConfiguration", (Object)this.ebsConfiguration()).add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("CustomAmiId", (Object)this.customAmiId()).add("Priority", (Object)this.priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "BidPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPrice()));
            }
            case "BidPriceAsPercentageOfOnDemandPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPriceAsPercentageOfOnDemandPrice()));
            }
            case "EbsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ebsConfiguration()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "CustomAmiId": {
                return Optional.ofNullable(clazz.cast(this.customAmiId()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("WeightedCapacity", WEIGHTED_CAPACITY_FIELD);
        map.put("BidPrice", BID_PRICE_FIELD);
        map.put("BidPriceAsPercentageOfOnDemandPrice", BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD);
        map.put("EbsConfiguration", EBS_CONFIGURATION_FIELD);
        map.put("Configurations", CONFIGURATIONS_FIELD);
        map.put("CustomAmiId", CUSTOM_AMI_ID_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeConfig, T> g) {
        return obj -> g.apply((InstanceTypeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer weightedCapacity;
        private String bidPrice;
        private Double bidPriceAsPercentageOfOnDemandPrice;
        private EbsConfiguration ebsConfiguration;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private String customAmiId;
        private Double priority;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeConfig model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.bidPrice(model.bidPrice);
            this.bidPriceAsPercentageOfOnDemandPrice(model.bidPriceAsPercentageOfOnDemandPrice);
            this.ebsConfiguration(model.ebsConfiguration);
            this.configurations(model.configurations);
            this.customAmiId(model.customAmiId);
            this.priority(model.priority);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final Double getBidPriceAsPercentageOfOnDemandPrice() {
            return this.bidPriceAsPercentageOfOnDemandPrice;
        }

        public final void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
        }

        @Override
        public final Builder bidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        public final EbsConfiguration.Builder getEbsConfiguration() {
            return this.ebsConfiguration != null ? this.ebsConfiguration.toBuilder() : null;
        }

        public final void setEbsConfiguration(EbsConfiguration.BuilderImpl ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration != null ? ebsConfiguration.build() : null;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCustomAmiId() {
            return this.customAmiId;
        }

        public final void setCustomAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
        }

        @Override
        public final Builder customAmiId(String customAmiId) {
            this.customAmiId = customAmiId;
            return this;
        }

        public final Double getPriority() {
            return this.priority;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public InstanceTypeConfig build() {
            return new InstanceTypeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeConfig> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(Integer var1);

        public Builder bidPrice(String var1);

        public Builder bidPriceAsPercentageOfOnDemandPrice(Double var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        default public Builder ebsConfiguration(Consumer<EbsConfiguration.Builder> ebsConfiguration) {
            return this.ebsConfiguration((EbsConfiguration)((EbsConfiguration.Builder)EbsConfiguration.builder().applyMutation(ebsConfiguration)).build());
        }

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder customAmiId(String var1);

        public Builder priority(Double var1);
    }
}

