/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.NotebookExecutionStatus;
import software.amazon.awssdk.services.emr.model.NotebookS3LocationForOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotebookExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotebookExecutionSummary> {
    private static final SdkField<String> NOTEBOOK_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionId").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::notebookExecutionId)).setter(NotebookExecutionSummary.setter(Builder::notebookExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionId").build()}).build();
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EditorId").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::editorId)).setter(NotebookExecutionSummary.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<String> NOTEBOOK_EXECUTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotebookExecutionName").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::notebookExecutionName)).setter(NotebookExecutionSummary.setter(Builder::notebookExecutionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookExecutionName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::statusAsString)).setter(NotebookExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::startTime)).setter(NotebookExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::endTime)).setter(NotebookExecutionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<NotebookS3LocationForOutput> NOTEBOOK_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotebookS3Location").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::notebookS3Location)).setter(NotebookExecutionSummary.setter(Builder::notebookS3Location)).constructor(NotebookS3LocationForOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookS3Location").build()}).build();
    private static final SdkField<String> EXECUTION_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionEngineId").getter(NotebookExecutionSummary.getter(NotebookExecutionSummary::executionEngineId)).setter(NotebookExecutionSummary.setter(Builder::executionEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngineId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_EXECUTION_ID_FIELD, EDITOR_ID_FIELD, NOTEBOOK_EXECUTION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, NOTEBOOK_S3_LOCATION_FIELD, EXECUTION_ENGINE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotebookExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String notebookExecutionId;
    private final String editorId;
    private final String notebookExecutionName;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final NotebookS3LocationForOutput notebookS3Location;
    private final String executionEngineId;

    private NotebookExecutionSummary(BuilderImpl builder) {
        this.notebookExecutionId = builder.notebookExecutionId;
        this.editorId = builder.editorId;
        this.notebookExecutionName = builder.notebookExecutionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.notebookS3Location = builder.notebookS3Location;
        this.executionEngineId = builder.executionEngineId;
    }

    public final String notebookExecutionId() {
        return this.notebookExecutionId;
    }

    public final String editorId() {
        return this.editorId;
    }

    public final String notebookExecutionName() {
        return this.notebookExecutionName;
    }

    public final NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final NotebookS3LocationForOutput notebookS3Location() {
        return this.notebookS3Location;
    }

    public final String executionEngineId() {
        return this.executionEngineId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.notebookS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEngineId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotebookExecutionSummary)) {
            return false;
        }
        NotebookExecutionSummary other = (NotebookExecutionSummary)obj;
        return Objects.equals(this.notebookExecutionId(), other.notebookExecutionId()) && Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.notebookExecutionName(), other.notebookExecutionName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.notebookS3Location(), other.notebookS3Location()) && Objects.equals(this.executionEngineId(), other.executionEngineId());
    }

    public final String toString() {
        return ToString.builder((String)"NotebookExecutionSummary").add("NotebookExecutionId", (Object)this.notebookExecutionId()).add("EditorId", (Object)this.editorId()).add("NotebookExecutionName", (Object)this.notebookExecutionName()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("NotebookS3Location", (Object)this.notebookS3Location()).add("ExecutionEngineId", (Object)this.executionEngineId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotebookExecutionId": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionId()));
            }
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "NotebookExecutionName": {
                return Optional.ofNullable(clazz.cast(this.notebookExecutionName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "NotebookS3Location": {
                return Optional.ofNullable(clazz.cast(this.notebookS3Location()));
            }
            case "ExecutionEngineId": {
                return Optional.ofNullable(clazz.cast(this.executionEngineId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotebookExecutionId", NOTEBOOK_EXECUTION_ID_FIELD);
        map.put("EditorId", EDITOR_ID_FIELD);
        map.put("NotebookExecutionName", NOTEBOOK_EXECUTION_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("NotebookS3Location", NOTEBOOK_S3_LOCATION_FIELD);
        map.put("ExecutionEngineId", EXECUTION_ENGINE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotebookExecutionSummary, T> g) {
        return obj -> g.apply((NotebookExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String notebookExecutionId;
        private String editorId;
        private String notebookExecutionName;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private NotebookS3LocationForOutput notebookS3Location;
        private String executionEngineId;

        private BuilderImpl() {
        }

        private BuilderImpl(NotebookExecutionSummary model) {
            this.notebookExecutionId(model.notebookExecutionId);
            this.editorId(model.editorId);
            this.notebookExecutionName(model.notebookExecutionName);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.notebookS3Location(model.notebookS3Location);
            this.executionEngineId(model.executionEngineId);
        }

        public final String getNotebookExecutionId() {
            return this.notebookExecutionId;
        }

        public final void setNotebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
        }

        @Override
        public final Builder notebookExecutionId(String notebookExecutionId) {
            this.notebookExecutionId = notebookExecutionId;
            return this;
        }

        public final String getEditorId() {
            return this.editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final String getNotebookExecutionName() {
            return this.notebookExecutionName;
        }

        public final void setNotebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
        }

        @Override
        public final Builder notebookExecutionName(String notebookExecutionName) {
            this.notebookExecutionName = notebookExecutionName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final NotebookS3LocationForOutput.Builder getNotebookS3Location() {
            return this.notebookS3Location != null ? this.notebookS3Location.toBuilder() : null;
        }

        public final void setNotebookS3Location(NotebookS3LocationForOutput.BuilderImpl notebookS3Location) {
            this.notebookS3Location = notebookS3Location != null ? notebookS3Location.build() : null;
        }

        @Override
        public final Builder notebookS3Location(NotebookS3LocationForOutput notebookS3Location) {
            this.notebookS3Location = notebookS3Location;
            return this;
        }

        public final String getExecutionEngineId() {
            return this.executionEngineId;
        }

        public final void setExecutionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
        }

        @Override
        public final Builder executionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
            return this;
        }

        public NotebookExecutionSummary build() {
            return new NotebookExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotebookExecutionSummary> {
        public Builder notebookExecutionId(String var1);

        public Builder editorId(String var1);

        public Builder notebookExecutionName(String var1);

        public Builder status(String var1);

        public Builder status(NotebookExecutionStatus var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder notebookS3Location(NotebookS3LocationForOutput var1);

        default public Builder notebookS3Location(Consumer<NotebookS3LocationForOutput.Builder> notebookS3Location) {
            return this.notebookS3Location((NotebookS3LocationForOutput)((NotebookS3LocationForOutput.Builder)NotebookS3LocationForOutput.builder().applyMutation(notebookS3Location)).build());
        }

        public Builder executionEngineId(String var1);
    }
}

