/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.GeoRoutesResponse;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnection;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationConnectionListCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypoint;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationImpedingWaypointListCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypoint;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationOptimizedWaypointListCopier;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationTimeBreakdown;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptimizeWaypointsResponse
extends GeoRoutesResponse
implements ToCopyableBuilder<Builder, OptimizeWaypointsResponse> {
    private static final SdkField<List<WaypointOptimizationConnection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Connections").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::connections)).setter(OptimizeWaypointsResponse.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::distance)).setter(OptimizeWaypointsResponse.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<Long> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Duration").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::duration)).setter(OptimizeWaypointsResponse.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<List<WaypointOptimizationImpedingWaypoint>> IMPEDING_WAYPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImpedingWaypoints").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::impedingWaypoints)).setter(OptimizeWaypointsResponse.setter(Builder::impedingWaypoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpedingWaypoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationImpedingWaypoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WaypointOptimizationOptimizedWaypoint>> OPTIMIZED_WAYPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptimizedWaypoints").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::optimizedWaypoints)).setter(OptimizeWaypointsResponse.setter(Builder::optimizedWaypoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizedWaypoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WaypointOptimizationOptimizedWaypoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::pricingBucket)).setter(OptimizeWaypointsResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<WaypointOptimizationTimeBreakdown> TIME_BREAKDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeBreakdown").getter(OptimizeWaypointsResponse.getter(OptimizeWaypointsResponse::timeBreakdown)).setter(OptimizeWaypointsResponse.setter(Builder::timeBreakdown)).constructor(WaypointOptimizationTimeBreakdown::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeBreakdown").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD, DISTANCE_FIELD, DURATION_FIELD, IMPEDING_WAYPOINTS_FIELD, OPTIMIZED_WAYPOINTS_FIELD, PRICING_BUCKET_FIELD, TIME_BREAKDOWN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OptimizeWaypointsResponse.memberNameToFieldInitializer();
    private final List<WaypointOptimizationConnection> connections;
    private final Long distance;
    private final Long duration;
    private final List<WaypointOptimizationImpedingWaypoint> impedingWaypoints;
    private final List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints;
    private final String pricingBucket;
    private final WaypointOptimizationTimeBreakdown timeBreakdown;

    private OptimizeWaypointsResponse(BuilderImpl builder) {
        super(builder);
        this.connections = builder.connections;
        this.distance = builder.distance;
        this.duration = builder.duration;
        this.impedingWaypoints = builder.impedingWaypoints;
        this.optimizedWaypoints = builder.optimizedWaypoints;
        this.pricingBucket = builder.pricingBucket;
        this.timeBreakdown = builder.timeBreakdown;
    }

    public final boolean hasConnections() {
        return this.connections != null && !(this.connections instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationConnection> connections() {
        return this.connections;
    }

    public final Long distance() {
        return this.distance;
    }

    public final Long duration() {
        return this.duration;
    }

    public final boolean hasImpedingWaypoints() {
        return this.impedingWaypoints != null && !(this.impedingWaypoints instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationImpedingWaypoint> impedingWaypoints() {
        return this.impedingWaypoints;
    }

    public final boolean hasOptimizedWaypoints() {
        return this.optimizedWaypoints != null && !(this.optimizedWaypoints instanceof SdkAutoConstructList);
    }

    public final List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints() {
        return this.optimizedWaypoints;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final WaypointOptimizationTimeBreakdown timeBreakdown() {
        return this.timeBreakdown;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnections() ? this.connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpedingWaypoints() ? this.impedingWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptimizedWaypoints() ? this.optimizedWaypoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBreakdown());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptimizeWaypointsResponse)) {
            return false;
        }
        OptimizeWaypointsResponse other = (OptimizeWaypointsResponse)((Object)obj);
        return this.hasConnections() == other.hasConnections() && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.duration(), other.duration()) && this.hasImpedingWaypoints() == other.hasImpedingWaypoints() && Objects.equals(this.impedingWaypoints(), other.impedingWaypoints()) && this.hasOptimizedWaypoints() == other.hasOptimizedWaypoints() && Objects.equals(this.optimizedWaypoints(), other.optimizedWaypoints()) && Objects.equals(this.pricingBucket(), other.pricingBucket()) && Objects.equals(this.timeBreakdown(), other.timeBreakdown());
    }

    public final String toString() {
        return ToString.builder((String)"OptimizeWaypointsResponse").add("Connections", this.hasConnections() ? this.connections() : null).add("Distance", (Object)(this.distance() == null ? null : "*** Sensitive Data Redacted ***")).add("Duration", (Object)(this.duration() == null ? null : "*** Sensitive Data Redacted ***")).add("ImpedingWaypoints", this.hasImpedingWaypoints() ? this.impedingWaypoints() : null).add("OptimizedWaypoints", this.hasOptimizedWaypoints() ? this.optimizedWaypoints() : null).add("PricingBucket", (Object)this.pricingBucket()).add("TimeBreakdown", (Object)this.timeBreakdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ImpedingWaypoints": {
                return Optional.ofNullable(clazz.cast(this.impedingWaypoints()));
            }
            case "OptimizedWaypoints": {
                return Optional.ofNullable(clazz.cast(this.optimizedWaypoints()));
            }
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "TimeBreakdown": {
                return Optional.ofNullable(clazz.cast(this.timeBreakdown()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Duration", DURATION_FIELD);
        map.put("ImpedingWaypoints", IMPEDING_WAYPOINTS_FIELD);
        map.put("OptimizedWaypoints", OPTIMIZED_WAYPOINTS_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("TimeBreakdown", TIME_BREAKDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptimizeWaypointsResponse, T> g) {
        return obj -> g.apply((OptimizeWaypointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoRoutesResponse.BuilderImpl
    implements Builder {
        private List<WaypointOptimizationConnection> connections = DefaultSdkAutoConstructList.getInstance();
        private Long distance;
        private Long duration;
        private List<WaypointOptimizationImpedingWaypoint> impedingWaypoints = DefaultSdkAutoConstructList.getInstance();
        private List<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints = DefaultSdkAutoConstructList.getInstance();
        private String pricingBucket;
        private WaypointOptimizationTimeBreakdown timeBreakdown;

        private BuilderImpl() {
        }

        private BuilderImpl(OptimizeWaypointsResponse model) {
            super(model);
            this.connections(model.connections);
            this.distance(model.distance);
            this.duration(model.duration);
            this.impedingWaypoints(model.impedingWaypoints);
            this.optimizedWaypoints(model.optimizedWaypoints);
            this.pricingBucket(model.pricingBucket);
            this.timeBreakdown(model.timeBreakdown);
        }

        public final List<WaypointOptimizationConnection.Builder> getConnections() {
            List<WaypointOptimizationConnection.Builder> result = WaypointOptimizationConnectionListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<WaypointOptimizationConnection.BuilderImpl> connections) {
            this.connections = WaypointOptimizationConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<WaypointOptimizationConnection> connections) {
            this.connections = WaypointOptimizationConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(WaypointOptimizationConnection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<WaypointOptimizationConnection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (WaypointOptimizationConnection)((WaypointOptimizationConnection.Builder)WaypointOptimizationConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final List<WaypointOptimizationImpedingWaypoint.Builder> getImpedingWaypoints() {
            List<WaypointOptimizationImpedingWaypoint.Builder> result = WaypointOptimizationImpedingWaypointListCopier.copyToBuilder(this.impedingWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint.BuilderImpl> impedingWaypoints) {
            this.impedingWaypoints = WaypointOptimizationImpedingWaypointListCopier.copyFromBuilder(impedingWaypoints);
        }

        @Override
        public final Builder impedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint> impedingWaypoints) {
            this.impedingWaypoints = WaypointOptimizationImpedingWaypointListCopier.copy(impedingWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impedingWaypoints(WaypointOptimizationImpedingWaypoint ... impedingWaypoints) {
            this.impedingWaypoints(Arrays.asList(impedingWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impedingWaypoints(Consumer<WaypointOptimizationImpedingWaypoint.Builder> ... impedingWaypoints) {
            this.impedingWaypoints(Stream.of(impedingWaypoints).map(c -> (WaypointOptimizationImpedingWaypoint)((WaypointOptimizationImpedingWaypoint.Builder)WaypointOptimizationImpedingWaypoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WaypointOptimizationOptimizedWaypoint.Builder> getOptimizedWaypoints() {
            List<WaypointOptimizationOptimizedWaypoint.Builder> result = WaypointOptimizationOptimizedWaypointListCopier.copyToBuilder(this.optimizedWaypoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint.BuilderImpl> optimizedWaypoints) {
            this.optimizedWaypoints = WaypointOptimizationOptimizedWaypointListCopier.copyFromBuilder(optimizedWaypoints);
        }

        @Override
        public final Builder optimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint> optimizedWaypoints) {
            this.optimizedWaypoints = WaypointOptimizationOptimizedWaypointListCopier.copy(optimizedWaypoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizedWaypoints(WaypointOptimizationOptimizedWaypoint ... optimizedWaypoints) {
            this.optimizedWaypoints(Arrays.asList(optimizedWaypoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optimizedWaypoints(Consumer<WaypointOptimizationOptimizedWaypoint.Builder> ... optimizedWaypoints) {
            this.optimizedWaypoints(Stream.of(optimizedWaypoints).map(c -> (WaypointOptimizationOptimizedWaypoint)((WaypointOptimizationOptimizedWaypoint.Builder)WaypointOptimizationOptimizedWaypoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final WaypointOptimizationTimeBreakdown.Builder getTimeBreakdown() {
            return this.timeBreakdown != null ? this.timeBreakdown.toBuilder() : null;
        }

        public final void setTimeBreakdown(WaypointOptimizationTimeBreakdown.BuilderImpl timeBreakdown) {
            this.timeBreakdown = timeBreakdown != null ? timeBreakdown.build() : null;
        }

        @Override
        public final Builder timeBreakdown(WaypointOptimizationTimeBreakdown timeBreakdown) {
            this.timeBreakdown = timeBreakdown;
            return this;
        }

        @Override
        public OptimizeWaypointsResponse build() {
            return new OptimizeWaypointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GeoRoutesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OptimizeWaypointsResponse> {
        public Builder connections(Collection<WaypointOptimizationConnection> var1);

        public Builder connections(WaypointOptimizationConnection ... var1);

        public Builder connections(Consumer<WaypointOptimizationConnection.Builder> ... var1);

        public Builder distance(Long var1);

        public Builder duration(Long var1);

        public Builder impedingWaypoints(Collection<WaypointOptimizationImpedingWaypoint> var1);

        public Builder impedingWaypoints(WaypointOptimizationImpedingWaypoint ... var1);

        public Builder impedingWaypoints(Consumer<WaypointOptimizationImpedingWaypoint.Builder> ... var1);

        public Builder optimizedWaypoints(Collection<WaypointOptimizationOptimizedWaypoint> var1);

        public Builder optimizedWaypoints(WaypointOptimizationOptimizedWaypoint ... var1);

        public Builder optimizedWaypoints(Consumer<WaypointOptimizationOptimizedWaypoint.Builder> ... var1);

        public Builder pricingBucket(String var1);

        public Builder timeBreakdown(WaypointOptimizationTimeBreakdown var1);

        default public Builder timeBreakdown(Consumer<WaypointOptimizationTimeBreakdown.Builder> timeBreakdown) {
            return this.timeBreakdown((WaypointOptimizationTimeBreakdown)((WaypointOptimizationTimeBreakdown.Builder)WaypointOptimizationTimeBreakdown.builder().applyMutation(timeBreakdown)).build());
        }
    }
}

