/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteMatrixTruckType {
    LIGHT_TRUCK("LightTruck"),
    STRAIGHT_TRUCK("StraightTruck"),
    TRACTOR("Tractor"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteMatrixTruckType> VALUE_MAP;
    private final String value;

    private RouteMatrixTruckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteMatrixTruckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteMatrixTruckType> knownValues() {
        EnumSet<RouteMatrixTruckType> knownValues = EnumSet.allOf(RouteMatrixTruckType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteMatrixTruckType.class, RouteMatrixTruckType::toString);
    }
}

