/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteNoticeImpact {
    HIGH("High"),
    LOW("Low"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteNoticeImpact> VALUE_MAP;
    private final String value;

    private RouteNoticeImpact(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteNoticeImpact fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteNoticeImpact> knownValues() {
        EnumSet<RouteNoticeImpact> knownValues = EnumSet.allOf(RouteNoticeImpact.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteNoticeImpact.class, RouteNoticeImpact::toString);
    }
}

