/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.georoutes.model.RouteTollPass;
import software.amazon.awssdk.services.georoutes.model.RouteTollPaymentMethod;
import software.amazon.awssdk.services.georoutes.model.RouteTollPaymentMethodListCopier;
import software.amazon.awssdk.services.georoutes.model.RouteTollPrice;
import software.amazon.awssdk.services.georoutes.model.RouteTransponder;
import software.amazon.awssdk.services.georoutes.model.RouteTransponderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteTollRate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteTollRate> {
    private static final SdkField<String> APPLICABLE_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicableTimes").getter(RouteTollRate.getter(RouteTollRate::applicableTimes)).setter(RouteTollRate.setter(Builder::applicableTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicableTimes").build()}).build();
    private static final SdkField<RouteTollPrice> CONVERTED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConvertedPrice").getter(RouteTollRate.getter(RouteTollRate::convertedPrice)).setter(RouteTollRate.setter(Builder::convertedPrice)).constructor(RouteTollPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConvertedPrice").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RouteTollRate.getter(RouteTollRate::id)).setter(RouteTollRate.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<RouteTollPrice> LOCAL_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalPrice").getter(RouteTollRate.getter(RouteTollRate::localPrice)).setter(RouteTollRate.setter(Builder::localPrice)).constructor(RouteTollPrice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPrice").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RouteTollRate.getter(RouteTollRate::name)).setter(RouteTollRate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RouteTollPass> PASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pass").getter(RouteTollRate.getter(RouteTollRate::pass)).setter(RouteTollRate.setter(Builder::pass)).constructor(RouteTollPass::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pass").build()}).build();
    private static final SdkField<List<String>> PAYMENT_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PaymentMethods").getter(RouteTollRate.getter(RouteTollRate::paymentMethodsAsStrings)).setter(RouteTollRate.setter(Builder::paymentMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RouteTransponder>> TRANSPONDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Transponders").getter(RouteTollRate.getter(RouteTollRate::transponders)).setter(RouteTollRate.setter(Builder::transponders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transponders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteTransponder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_TIMES_FIELD, CONVERTED_PRICE_FIELD, ID_FIELD, LOCAL_PRICE_FIELD, NAME_FIELD, PASS_FIELD, PAYMENT_METHODS_FIELD, TRANSPONDERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteTollRate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicableTimes;
    private final RouteTollPrice convertedPrice;
    private final String id;
    private final RouteTollPrice localPrice;
    private final String name;
    private final RouteTollPass pass;
    private final List<String> paymentMethods;
    private final List<RouteTransponder> transponders;

    private RouteTollRate(BuilderImpl builder) {
        this.applicableTimes = builder.applicableTimes;
        this.convertedPrice = builder.convertedPrice;
        this.id = builder.id;
        this.localPrice = builder.localPrice;
        this.name = builder.name;
        this.pass = builder.pass;
        this.paymentMethods = builder.paymentMethods;
        this.transponders = builder.transponders;
    }

    public final String applicableTimes() {
        return this.applicableTimes;
    }

    public final RouteTollPrice convertedPrice() {
        return this.convertedPrice;
    }

    public final String id() {
        return this.id;
    }

    public final RouteTollPrice localPrice() {
        return this.localPrice;
    }

    public final String name() {
        return this.name;
    }

    public final RouteTollPass pass() {
        return this.pass;
    }

    public final List<RouteTollPaymentMethod> paymentMethods() {
        return RouteTollPaymentMethodListCopier.copyStringToEnum(this.paymentMethods);
    }

    public final boolean hasPaymentMethods() {
        return this.paymentMethods != null && !(this.paymentMethods instanceof SdkAutoConstructList);
    }

    public final List<String> paymentMethodsAsStrings() {
        return this.paymentMethods;
    }

    public final boolean hasTransponders() {
        return this.transponders != null && !(this.transponders instanceof SdkAutoConstructList);
    }

    public final List<RouteTransponder> transponders() {
        return this.transponders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicableTimes());
        hashCode = 31 * hashCode + Objects.hashCode(this.convertedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pass());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPaymentMethods() ? this.paymentMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransponders() ? this.transponders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTollRate)) {
            return false;
        }
        RouteTollRate other = (RouteTollRate)obj;
        return Objects.equals(this.applicableTimes(), other.applicableTimes()) && Objects.equals(this.convertedPrice(), other.convertedPrice()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.localPrice(), other.localPrice()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pass(), other.pass()) && this.hasPaymentMethods() == other.hasPaymentMethods() && Objects.equals(this.paymentMethodsAsStrings(), other.paymentMethodsAsStrings()) && this.hasTransponders() == other.hasTransponders() && Objects.equals(this.transponders(), other.transponders());
    }

    public final String toString() {
        return ToString.builder((String)"RouteTollRate").add("ApplicableTimes", (Object)(this.applicableTimes() == null ? null : "*** Sensitive Data Redacted ***")).add("ConvertedPrice", (Object)this.convertedPrice()).add("Id", (Object)(this.id() == null ? null : "*** Sensitive Data Redacted ***")).add("LocalPrice", (Object)this.localPrice()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Pass", (Object)this.pass()).add("PaymentMethods", (Object)(this.paymentMethodsAsStrings() == null ? null : "*** Sensitive Data Redacted ***")).add("Transponders", this.hasTransponders() ? this.transponders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicableTimes": {
                return Optional.ofNullable(clazz.cast(this.applicableTimes()));
            }
            case "ConvertedPrice": {
                return Optional.ofNullable(clazz.cast(this.convertedPrice()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "LocalPrice": {
                return Optional.ofNullable(clazz.cast(this.localPrice()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Pass": {
                return Optional.ofNullable(clazz.cast(this.pass()));
            }
            case "PaymentMethods": {
                return Optional.ofNullable(clazz.cast(this.paymentMethodsAsStrings()));
            }
            case "Transponders": {
                return Optional.ofNullable(clazz.cast(this.transponders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicableTimes", APPLICABLE_TIMES_FIELD);
        map.put("ConvertedPrice", CONVERTED_PRICE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LocalPrice", LOCAL_PRICE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Pass", PASS_FIELD);
        map.put("PaymentMethods", PAYMENT_METHODS_FIELD);
        map.put("Transponders", TRANSPONDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTollRate, T> g) {
        return obj -> g.apply((RouteTollRate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicableTimes;
        private RouteTollPrice convertedPrice;
        private String id;
        private RouteTollPrice localPrice;
        private String name;
        private RouteTollPass pass;
        private List<String> paymentMethods = DefaultSdkAutoConstructList.getInstance();
        private List<RouteTransponder> transponders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTollRate model) {
            this.applicableTimes(model.applicableTimes);
            this.convertedPrice(model.convertedPrice);
            this.id(model.id);
            this.localPrice(model.localPrice);
            this.name(model.name);
            this.pass(model.pass);
            this.paymentMethodsWithStrings(model.paymentMethods);
            this.transponders(model.transponders);
        }

        public final String getApplicableTimes() {
            return this.applicableTimes;
        }

        public final void setApplicableTimes(String applicableTimes) {
            this.applicableTimes = applicableTimes;
        }

        @Override
        public final Builder applicableTimes(String applicableTimes) {
            this.applicableTimes = applicableTimes;
            return this;
        }

        public final RouteTollPrice.Builder getConvertedPrice() {
            return this.convertedPrice != null ? this.convertedPrice.toBuilder() : null;
        }

        public final void setConvertedPrice(RouteTollPrice.BuilderImpl convertedPrice) {
            this.convertedPrice = convertedPrice != null ? convertedPrice.build() : null;
        }

        @Override
        public final Builder convertedPrice(RouteTollPrice convertedPrice) {
            this.convertedPrice = convertedPrice;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final RouteTollPrice.Builder getLocalPrice() {
            return this.localPrice != null ? this.localPrice.toBuilder() : null;
        }

        public final void setLocalPrice(RouteTollPrice.BuilderImpl localPrice) {
            this.localPrice = localPrice != null ? localPrice.build() : null;
        }

        @Override
        public final Builder localPrice(RouteTollPrice localPrice) {
            this.localPrice = localPrice;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RouteTollPass.Builder getPass() {
            return this.pass != null ? this.pass.toBuilder() : null;
        }

        public final void setPass(RouteTollPass.BuilderImpl pass) {
            this.pass = pass != null ? pass.build() : null;
        }

        @Override
        public final Builder pass(RouteTollPass pass) {
            this.pass = pass;
            return this;
        }

        public final Collection<String> getPaymentMethods() {
            if (this.paymentMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.paymentMethods;
        }

        public final void setPaymentMethods(Collection<String> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copy(paymentMethods);
        }

        @Override
        public final Builder paymentMethodsWithStrings(Collection<String> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copy(paymentMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentMethodsWithStrings(String ... paymentMethods) {
            this.paymentMethodsWithStrings(Arrays.asList(paymentMethods));
            return this;
        }

        @Override
        public final Builder paymentMethods(Collection<RouteTollPaymentMethod> paymentMethods) {
            this.paymentMethods = RouteTollPaymentMethodListCopier.copyEnumToString(paymentMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder paymentMethods(RouteTollPaymentMethod ... paymentMethods) {
            this.paymentMethods(Arrays.asList(paymentMethods));
            return this;
        }

        public final List<RouteTransponder.Builder> getTransponders() {
            List<RouteTransponder.Builder> result = RouteTransponderListCopier.copyToBuilder(this.transponders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransponders(Collection<RouteTransponder.BuilderImpl> transponders) {
            this.transponders = RouteTransponderListCopier.copyFromBuilder(transponders);
        }

        @Override
        public final Builder transponders(Collection<RouteTransponder> transponders) {
            this.transponders = RouteTransponderListCopier.copy(transponders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transponders(RouteTransponder ... transponders) {
            this.transponders(Arrays.asList(transponders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transponders(Consumer<RouteTransponder.Builder> ... transponders) {
            this.transponders(Stream.of(transponders).map(c -> (RouteTransponder)((RouteTransponder.Builder)RouteTransponder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RouteTollRate build() {
            return new RouteTollRate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteTollRate> {
        public Builder applicableTimes(String var1);

        public Builder convertedPrice(RouteTollPrice var1);

        default public Builder convertedPrice(Consumer<RouteTollPrice.Builder> convertedPrice) {
            return this.convertedPrice((RouteTollPrice)((RouteTollPrice.Builder)RouteTollPrice.builder().applyMutation(convertedPrice)).build());
        }

        public Builder id(String var1);

        public Builder localPrice(RouteTollPrice var1);

        default public Builder localPrice(Consumer<RouteTollPrice.Builder> localPrice) {
            return this.localPrice((RouteTollPrice)((RouteTollPrice.Builder)RouteTollPrice.builder().applyMutation(localPrice)).build());
        }

        public Builder name(String var1);

        public Builder pass(RouteTollPass var1);

        default public Builder pass(Consumer<RouteTollPass.Builder> pass) {
            return this.pass((RouteTollPass)((RouteTollPass.Builder)RouteTollPass.builder().applyMutation(pass)).build());
        }

        public Builder paymentMethodsWithStrings(Collection<String> var1);

        public Builder paymentMethodsWithStrings(String ... var1);

        public Builder paymentMethods(Collection<RouteTollPaymentMethod> var1);

        public Builder paymentMethods(RouteTollPaymentMethod ... var1);

        public Builder transponders(Collection<RouteTransponder> var1);

        public Builder transponders(RouteTransponder ... var1);

        public Builder transponders(Consumer<RouteTransponder.Builder> ... var1);
    }
}

