/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationClusteringAlgorithm;
import software.amazon.awssdk.services.georoutes.model.WaypointOptimizationDrivingDistanceOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaypointOptimizationClusteringOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaypointOptimizationClusteringOptions> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Algorithm").getter(WaypointOptimizationClusteringOptions.getter(WaypointOptimizationClusteringOptions::algorithmAsString)).setter(WaypointOptimizationClusteringOptions.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()}).build();
    private static final SdkField<WaypointOptimizationDrivingDistanceOptions> DRIVING_DISTANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DrivingDistanceOptions").getter(WaypointOptimizationClusteringOptions.getter(WaypointOptimizationClusteringOptions::drivingDistanceOptions)).setter(WaypointOptimizationClusteringOptions.setter(Builder::drivingDistanceOptions)).constructor(WaypointOptimizationDrivingDistanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrivingDistanceOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, DRIVING_DISTANCE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaypointOptimizationClusteringOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final WaypointOptimizationDrivingDistanceOptions drivingDistanceOptions;

    private WaypointOptimizationClusteringOptions(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.drivingDistanceOptions = builder.drivingDistanceOptions;
    }

    public final WaypointOptimizationClusteringAlgorithm algorithm() {
        return WaypointOptimizationClusteringAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final WaypointOptimizationDrivingDistanceOptions drivingDistanceOptions() {
        return this.drivingDistanceOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.drivingDistanceOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaypointOptimizationClusteringOptions)) {
            return false;
        }
        WaypointOptimizationClusteringOptions other = (WaypointOptimizationClusteringOptions)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.drivingDistanceOptions(), other.drivingDistanceOptions());
    }

    public final String toString() {
        return ToString.builder((String)"WaypointOptimizationClusteringOptions").add("Algorithm", (Object)(this.algorithmAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("DrivingDistanceOptions", (Object)this.drivingDistanceOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "DrivingDistanceOptions": {
                return Optional.ofNullable(clazz.cast(this.drivingDistanceOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Algorithm", ALGORITHM_FIELD);
        map.put("DrivingDistanceOptions", DRIVING_DISTANCE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaypointOptimizationClusteringOptions, T> g) {
        return obj -> g.apply((WaypointOptimizationClusteringOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private WaypointOptimizationDrivingDistanceOptions drivingDistanceOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(WaypointOptimizationClusteringOptions model) {
            this.algorithm(model.algorithm);
            this.drivingDistanceOptions(model.drivingDistanceOptions);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(WaypointOptimizationClusteringAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final WaypointOptimizationDrivingDistanceOptions.Builder getDrivingDistanceOptions() {
            return this.drivingDistanceOptions != null ? this.drivingDistanceOptions.toBuilder() : null;
        }

        public final void setDrivingDistanceOptions(WaypointOptimizationDrivingDistanceOptions.BuilderImpl drivingDistanceOptions) {
            this.drivingDistanceOptions = drivingDistanceOptions != null ? drivingDistanceOptions.build() : null;
        }

        @Override
        public final Builder drivingDistanceOptions(WaypointOptimizationDrivingDistanceOptions drivingDistanceOptions) {
            this.drivingDistanceOptions = drivingDistanceOptions;
            return this;
        }

        public WaypointOptimizationClusteringOptions build() {
            return new WaypointOptimizationClusteringOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaypointOptimizationClusteringOptions> {
        public Builder algorithm(String var1);

        public Builder algorithm(WaypointOptimizationClusteringAlgorithm var1);

        public Builder drivingDistanceOptions(WaypointOptimizationDrivingDistanceOptions var1);

        default public Builder drivingDistanceOptions(Consumer<WaypointOptimizationDrivingDistanceOptions.Builder> drivingDistanceOptions) {
            return this.drivingDistanceOptions((WaypointOptimizationDrivingDistanceOptions)((WaypointOptimizationDrivingDistanceOptions.Builder)WaypointOptimizationDrivingDistanceOptions.builder().applyMutation(drivingDistanceOptions)).build());
        }
    }
}

