/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AdditionalOptionKeys {
    PERFORMANCE_TUNING_CACHING("performanceTuning.caching"),
    OBSERVATIONS_SCOPE("observations.scope"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AdditionalOptionKeys> VALUE_MAP;
    private final String value;

    private AdditionalOptionKeys(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AdditionalOptionKeys fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AdditionalOptionKeys> knownValues() {
        EnumSet<AdditionalOptionKeys> knownValues = EnumSet.allOf(AdditionalOptionKeys.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AdditionalOptionKeys.class, AdditionalOptionKeys::toString);
    }
}

