/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;

public class ListVersionsByFunctionIterable
implements SdkIterable<ListVersionsByFunctionResponse> {
    private final LambdaClient client;
    private final ListVersionsByFunctionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVersionsByFunctionIterable(LambdaClient client, ListVersionsByFunctionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVersionsByFunctionResponseFetcher();
    }

    public Iterator<ListVersionsByFunctionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FunctionConfiguration> versions() {
        Function<ListVersionsByFunctionResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVersionsByFunctionResponseFetcher
    implements SyncPageFetcher<ListVersionsByFunctionResponse> {
        private ListVersionsByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListVersionsByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListVersionsByFunctionResponse nextPage(ListVersionsByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListVersionsByFunctionIterable.this.client.listVersionsByFunction(ListVersionsByFunctionIterable.this.firstRequest);
            }
            return ListVersionsByFunctionIterable.this.client.listVersionsByFunction((ListVersionsByFunctionRequest)((Object)ListVersionsByFunctionIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

