/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.location.model.LocationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGeofenceCollectionResponse
extends LocationResponse
implements ToCopyableBuilder<Builder, CreateGeofenceCollectionResponse> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionName").getter(CreateGeofenceCollectionResponse.getter(CreateGeofenceCollectionResponse::collectionName)).setter(CreateGeofenceCollectionResponse.setter(Builder::collectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionName").build()}).build();
    private static final SdkField<String> COLLECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionArn").getter(CreateGeofenceCollectionResponse.getter(CreateGeofenceCollectionResponse::collectionArn)).setter(CreateGeofenceCollectionResponse.setter(Builder::collectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(CreateGeofenceCollectionResponse.getter(CreateGeofenceCollectionResponse::createTime)).setter(CreateGeofenceCollectionResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD, COLLECTION_ARN_FIELD, CREATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGeofenceCollectionResponse.memberNameToFieldInitializer();
    private final String collectionName;
    private final String collectionArn;
    private final Instant createTime;

    private CreateGeofenceCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionName = builder.collectionName;
        this.collectionArn = builder.collectionArn;
        this.createTime = builder.createTime;
    }

    public final String collectionName() {
        return this.collectionName;
    }

    public final String collectionArn() {
        return this.collectionArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGeofenceCollectionResponse)) {
            return false;
        }
        CreateGeofenceCollectionResponse other = (CreateGeofenceCollectionResponse)((Object)obj);
        return Objects.equals(this.collectionName(), other.collectionName()) && Objects.equals(this.collectionArn(), other.collectionArn()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGeofenceCollectionResponse").add("CollectionName", (Object)this.collectionName()).add("CollectionArn", (Object)this.collectionArn()).add("CreateTime", (Object)(this.createTime() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionName": {
                return Optional.ofNullable(clazz.cast(this.collectionName()));
            }
            case "CollectionArn": {
                return Optional.ofNullable(clazz.cast(this.collectionArn()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CollectionName", COLLECTION_NAME_FIELD);
        map.put("CollectionArn", COLLECTION_ARN_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGeofenceCollectionResponse, T> g) {
        return obj -> g.apply((CreateGeofenceCollectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LocationResponse.BuilderImpl
    implements Builder {
        private String collectionName;
        private String collectionArn;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGeofenceCollectionResponse model) {
            super(model);
            this.collectionName(model.collectionName);
            this.collectionArn(model.collectionArn);
            this.createTime(model.createTime);
        }

        public final String getCollectionName() {
            return this.collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getCollectionArn() {
            return this.collectionArn;
        }

        public final void setCollectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
        }

        @Override
        public final Builder collectionArn(String collectionArn) {
            this.collectionArn = collectionArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public CreateGeofenceCollectionResponse build() {
            return new CreateGeofenceCollectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LocationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGeofenceCollectionResponse> {
        public Builder collectionName(String var1);

        public Builder collectionArn(String var1);

        public Builder createTime(Instant var1);
    }
}

