/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.location.model.BoundingBoxCopier;
import software.amazon.awssdk.services.location.model.CountryCodeListCopier;
import software.amazon.awssdk.services.location.model.FilterPlaceCategoryListCopier;
import software.amazon.awssdk.services.location.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchPlaceIndexForSuggestionsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchPlaceIndexForSuggestionsSummary> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::text)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<List<Double>> BIAS_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BiasPosition").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::biasPosition)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::biasPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BiasPosition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> FILTER_B_BOX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterBBox").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::filterBBox)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::filterBBox)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterBBox").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FILTER_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterCountries").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::filterCountries)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::filterCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::maxResults)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSource").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::dataSource)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::language)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<List<String>> FILTER_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterCategories").getter(SearchPlaceIndexForSuggestionsSummary.getter(SearchPlaceIndexForSuggestionsSummary::filterCategories)).setter(SearchPlaceIndexForSuggestionsSummary.setter(Builder::filterCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, BIAS_POSITION_FIELD, FILTER_B_BOX_FIELD, FILTER_COUNTRIES_FIELD, MAX_RESULTS_FIELD, DATA_SOURCE_FIELD, LANGUAGE_FIELD, FILTER_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchPlaceIndexForSuggestionsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final List<Double> biasPosition;
    private final List<Double> filterBBox;
    private final List<String> filterCountries;
    private final Integer maxResults;
    private final String dataSource;
    private final String language;
    private final List<String> filterCategories;

    private SearchPlaceIndexForSuggestionsSummary(BuilderImpl builder) {
        this.text = builder.text;
        this.biasPosition = builder.biasPosition;
        this.filterBBox = builder.filterBBox;
        this.filterCountries = builder.filterCountries;
        this.maxResults = builder.maxResults;
        this.dataSource = builder.dataSource;
        this.language = builder.language;
        this.filterCategories = builder.filterCategories;
    }

    public final String text() {
        return this.text;
    }

    public final boolean hasBiasPosition() {
        return this.biasPosition != null && !(this.biasPosition instanceof SdkAutoConstructList);
    }

    public final List<Double> biasPosition() {
        return this.biasPosition;
    }

    public final boolean hasFilterBBox() {
        return this.filterBBox != null && !(this.filterBBox instanceof SdkAutoConstructList);
    }

    public final List<Double> filterBBox() {
        return this.filterBBox;
    }

    public final boolean hasFilterCountries() {
        return this.filterCountries != null && !(this.filterCountries instanceof SdkAutoConstructList);
    }

    public final List<String> filterCountries() {
        return this.filterCountries;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String dataSource() {
        return this.dataSource;
    }

    public final String language() {
        return this.language;
    }

    public final boolean hasFilterCategories() {
        return this.filterCategories != null && !(this.filterCategories instanceof SdkAutoConstructList);
    }

    public final List<String> filterCategories() {
        return this.filterCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBiasPosition() ? this.biasPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterBBox() ? this.filterBBox() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterCountries() ? this.filterCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterCategories() ? this.filterCategories() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPlaceIndexForSuggestionsSummary)) {
            return false;
        }
        SearchPlaceIndexForSuggestionsSummary other = (SearchPlaceIndexForSuggestionsSummary)obj;
        return Objects.equals(this.text(), other.text()) && this.hasBiasPosition() == other.hasBiasPosition() && Objects.equals(this.biasPosition(), other.biasPosition()) && this.hasFilterBBox() == other.hasFilterBBox() && Objects.equals(this.filterBBox(), other.filterBBox()) && this.hasFilterCountries() == other.hasFilterCountries() && Objects.equals(this.filterCountries(), other.filterCountries()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.dataSource(), other.dataSource()) && Objects.equals(this.language(), other.language()) && this.hasFilterCategories() == other.hasFilterCategories() && Objects.equals(this.filterCategories(), other.filterCategories());
    }

    public final String toString() {
        return ToString.builder((String)"SearchPlaceIndexForSuggestionsSummary").add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("BiasPosition", (Object)(this.biasPosition() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterBBox", (Object)(this.filterBBox() == null ? null : "*** Sensitive Data Redacted ***")).add("FilterCountries", (Object)(this.filterCountries() == null ? null : "*** Sensitive Data Redacted ***")).add("MaxResults", (Object)this.maxResults()).add("DataSource", (Object)this.dataSource()).add("Language", (Object)this.language()).add("FilterCategories", this.hasFilterCategories() ? this.filterCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "BiasPosition": {
                return Optional.ofNullable(clazz.cast(this.biasPosition()));
            }
            case "FilterBBox": {
                return Optional.ofNullable(clazz.cast(this.filterBBox()));
            }
            case "FilterCountries": {
                return Optional.ofNullable(clazz.cast(this.filterCountries()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "FilterCategories": {
                return Optional.ofNullable(clazz.cast(this.filterCategories()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Text", TEXT_FIELD);
        map.put("BiasPosition", BIAS_POSITION_FIELD);
        map.put("FilterBBox", FILTER_B_BOX_FIELD);
        map.put("FilterCountries", FILTER_COUNTRIES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("DataSource", DATA_SOURCE_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("FilterCategories", FILTER_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPlaceIndexForSuggestionsSummary, T> g) {
        return obj -> g.apply((SearchPlaceIndexForSuggestionsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private List<Double> biasPosition = DefaultSdkAutoConstructList.getInstance();
        private List<Double> filterBBox = DefaultSdkAutoConstructList.getInstance();
        private List<String> filterCountries = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String dataSource;
        private String language;
        private List<String> filterCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPlaceIndexForSuggestionsSummary model) {
            this.text(model.text);
            this.biasPosition(model.biasPosition);
            this.filterBBox(model.filterBBox);
            this.filterCountries(model.filterCountries);
            this.maxResults(model.maxResults);
            this.dataSource(model.dataSource);
            this.language(model.language);
            this.filterCategories(model.filterCategories);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Collection<Double> getBiasPosition() {
            if (this.biasPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return this.biasPosition;
        }

        public final void setBiasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
        }

        @Override
        public final Builder biasPosition(Collection<Double> biasPosition) {
            this.biasPosition = PositionCopier.copy(biasPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder biasPosition(Double ... biasPosition) {
            this.biasPosition(Arrays.asList(biasPosition));
            return this;
        }

        public final Collection<Double> getFilterBBox() {
            if (this.filterBBox instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterBBox;
        }

        public final void setFilterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
        }

        @Override
        public final Builder filterBBox(Collection<Double> filterBBox) {
            this.filterBBox = BoundingBoxCopier.copy(filterBBox);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterBBox(Double ... filterBBox) {
            this.filterBBox(Arrays.asList(filterBBox));
            return this;
        }

        public final Collection<String> getFilterCountries() {
            if (this.filterCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterCountries;
        }

        public final void setFilterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
        }

        @Override
        public final Builder filterCountries(Collection<String> filterCountries) {
            this.filterCountries = CountryCodeListCopier.copy(filterCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCountries(String ... filterCountries) {
            this.filterCountries(Arrays.asList(filterCountries));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Collection<String> getFilterCategories() {
            if (this.filterCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterCategories;
        }

        public final void setFilterCategories(Collection<String> filterCategories) {
            this.filterCategories = FilterPlaceCategoryListCopier.copy(filterCategories);
        }

        @Override
        public final Builder filterCategories(Collection<String> filterCategories) {
            this.filterCategories = FilterPlaceCategoryListCopier.copy(filterCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterCategories(String ... filterCategories) {
            this.filterCategories(Arrays.asList(filterCategories));
            return this;
        }

        public SearchPlaceIndexForSuggestionsSummary build() {
            return new SearchPlaceIndexForSuggestionsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchPlaceIndexForSuggestionsSummary> {
        public Builder text(String var1);

        public Builder biasPosition(Collection<Double> var1);

        public Builder biasPosition(Double ... var1);

        public Builder filterBBox(Collection<Double> var1);

        public Builder filterBBox(Double ... var1);

        public Builder filterCountries(Collection<String> var1);

        public Builder filterCountries(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder dataSource(String var1);

        public Builder language(String var1);

        public Builder filterCategories(Collection<String> var1);

        public Builder filterCategories(String ... var1);
    }
}

