/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StatusFlag {
    PENDING_ACCEPTANCE("PENDING_ACCEPTANCE"),
    PENDING_CUSTOMER_ACTION("PENDING_CUSTOMER_ACTION"),
    PENDING_AUTHORIZATION("PENDING_AUTHORIZATION"),
    PENDING_PAYMENT_VERIFICATION("PENDING_PAYMENT_VERIFICATION"),
    PENDING_SUPPORT_CASE("PENDING_SUPPORT_CASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StatusFlag> VALUE_MAP;
    private final String value;

    private StatusFlag(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusFlag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusFlag> knownValues() {
        EnumSet<StatusFlag> knownValues = EnumSet.allOf(StatusFlag.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StatusFlag.class, StatusFlag::toString);
    }
}

