/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.model;

import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.transfer.s3.model.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.FileDownload;
import software.amazon.awssdk.transfer.s3.model.ResumableFileDownload;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultFileDownload
implements FileDownload {
    private final CompletableFuture<CompletedFileDownload> completionFuture;
    private final Lazy<ResumableFileDownload> resumableFileDownload;
    private final TransferProgress progress;
    private final Supplier<DownloadFileRequest> requestSupplier;
    private final ResumableFileDownload resumedDownload;

    public DefaultFileDownload(CompletableFuture<CompletedFileDownload> completedFileDownloadFuture, TransferProgress progress, Supplier<DownloadFileRequest> requestSupplier, ResumableFileDownload resumedDownload) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completedFileDownloadFuture, (String)"completedFileDownloadFuture");
        this.progress = (TransferProgress)Validate.paramNotNull((Object)progress, (String)"progress");
        this.requestSupplier = (Supplier)Validate.paramNotNull(requestSupplier, (String)"requestSupplier");
        this.resumableFileDownload = new Lazy(this::doPause);
        this.resumedDownload = resumedDownload;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    @Override
    public ResumableFileDownload pause() {
        return (ResumableFileDownload)this.resumableFileDownload.getValue();
    }

    private ResumableFileDownload doPause() {
        this.completionFuture.cancel(true);
        Instant s3objectLastModified = null;
        String s3objectEtag = null;
        Long totalSizeInBytes = null;
        TransferProgressSnapshot snapshot = this.progress.snapshot();
        if (snapshot.sdkResponse().isPresent() && snapshot.sdkResponse().get() instanceof GetObjectResponse) {
            GetObjectResponse getObjectResponse = (GetObjectResponse)snapshot.sdkResponse().get();
            s3objectLastModified = getObjectResponse.lastModified();
            s3objectEtag = getObjectResponse.eTag();
            totalSizeInBytes = getObjectResponse.contentLength();
        } else if (this.resumedDownload != null) {
            s3objectLastModified = this.resumedDownload.s3ObjectLastModified().orElse(null);
            s3objectEtag = this.resumedDownload.s3ObjectEtag().orElse(null);
            totalSizeInBytes = this.resumedDownload.totalSizeInBytes().isPresent() ? Long.valueOf(this.resumedDownload.totalSizeInBytes().getAsLong()) : null;
        }
        DownloadFileRequest request = this.requestSupplier.get();
        File destination = request.destination().toFile();
        long length = destination.length();
        Instant fileLastModified = Instant.ofEpochMilli(destination.lastModified());
        List completedParts = MultipartDownloadUtils.completedParts((GetObjectRequest)request.getObjectRequest());
        return (ResumableFileDownload)ResumableFileDownload.builder().downloadFileRequest(request).s3ObjectLastModified(s3objectLastModified).s3ObjectEtag(s3objectEtag).fileLastModified(fileLastModified).bytesTransferred(length).totalSizeInBytes(totalSizeInBytes).completedParts(completedParts).build();
    }

    @Override
    public CompletableFuture<CompletedFileDownload> completionFuture() {
        return this.completionFuture;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileDownload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).add("request", (Object)this.requestSupplier.get()).build();
    }
}

