/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.amazonaws.services.timestreamquery.model.Type;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamResultSetMetaData;
import software.amazon.timestream.jdbc.TimestreamStatement;
import software.amazon.timestream.jdbc.TimestreamTablesResultSet;

public class TimestreamColumnsResultSet
extends TimestreamBaseResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamColumnsResultSet.class);
    private static final Datum NULL_DATUM = new Datum().withNullValue(Boolean.TRUE);
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_CAT"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_SCHEM"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "COLUMN_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "DATA_TYPE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TYPE_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "COLUMN_SIZE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "BUFFER_LENGTH"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "DECIMAL_DIGITS"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "NUM_PREC_RADIX"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "NULLABLE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "REMARKS"), (Object[])new ColumnInfo[]{TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "COLUMN_DEF"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SQL_DATA_TYPE"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SQL_DATETIME_SUB"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "CHAR_OCTET_LENGTH"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "ORDINAL_POSITION"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "IS_NULLABLE"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "SCOPE_CATALOG"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "SCOPE_SCHEMA"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "SCOPE_TABLE"), TimestreamDataType.createColumnInfo(TimestreamDataType.INTEGER, "SCOPE_DATA_TYPE"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "IS_AUTOINCREMENT"), TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "IS_GENERATEDCOLUMN")});
    private final int TABLE_SCHEM_INDX = 2;
    private final int TABLE_NAME_INDX = 3;
    private final TimestreamStatement statement;
    private ResultSet result;
    private final TimestreamTablesResultSet tablesResult;
    private final Matcher columnNameMatcher;
    private String curDatabase;
    private String curTable;

    TimestreamColumnsResultSet(TimestreamConnection connection, String database, String tableNamePattern, String columnNamePattern) throws SQLException {
        super(null, 1000);
        this.statement = connection.createStatement();
        this.tablesResult = new TimestreamTablesResultSet(connection, database, tableNamePattern, null);
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.columnNameMatcher = null == columnNamePattern ? Pattern.compile(".*").matcher("") : Pattern.compile(columnNamePattern).matcher("");
        this.doNextPage();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return !this.rowItr.hasNext() && this.tablesResult.isAfterLast();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        return null != this.result && this.result.isLast() && !this.rowItr.hasNext();
    }

    @Override
    protected void doClose() throws SQLException {
        this.statement.close();
    }

    @Override
    protected boolean doNextPage() throws SQLException {
        if (!this.tablesResult.next()) {
            this.result = null;
            return false;
        }
        this.curDatabase = this.tablesResult.getString(2);
        this.curTable = this.tablesResult.getString(3);
        this.result = this.statement.executeQuery(String.format("DESCRIBE \"%s\".\"%s\"", this.curDatabase, this.curTable));
        this.populateCurrentRows();
        return true;
    }

    private void populateCurrentRows() throws SQLException {
        ArrayList<TimestreamResultSetMetaData.ColInfo> colInfo = new ArrayList<TimestreamResultSetMetaData.ColInfo>();
        while (this.result.next()) {
            String columnName = this.result.getString(1);
            if (!this.columnNameMatcher.reset(columnName).matches()) continue;
            colInfo.add(new TimestreamResultSetMetaData.ColInfo(new Type().withScalarType(this.result.getString(2)), columnName));
        }
        TimestreamResultSetMetaData rsMeta = new TimestreamResultSetMetaData(colInfo);
        int numColumns = rsMeta.getColumnCount();
        ArrayList<Row> columns = new ArrayList<Row>();
        for (int i = 1; i <= numColumns; ++i) {
            int columnType = rsMeta.getColumnType(i);
            columns.add(new Row().withData(new Datum[]{NULL_DATUM, TimestreamColumnsResultSet.createDatum(this.curDatabase), TimestreamColumnsResultSet.createDatum(this.curTable), TimestreamColumnsResultSet.createDatum(rsMeta.getColumnName(i)), TimestreamColumnsResultSet.createDatum(columnType), TimestreamColumnsResultSet.createDatum(rsMeta.getColumnTypeName(i)), TimestreamColumnsResultSet.createDatum(rsMeta.getColumnDisplaySize(i)), NULL_DATUM, columnType == 92 || columnType == 93 ? TimestreamColumnsResultSet.createDatum(9) : NULL_DATUM, columnType == 8 ? TimestreamColumnsResultSet.createDatum(10) : NULL_DATUM, TimestreamColumnsResultSet.createDatum(1), NULL_DATUM, NULL_DATUM, TimestreamColumnsResultSet.createDatum(columnType), columnType == 91 || columnType == 92 || columnType == 93 ? TimestreamColumnsResultSet.createDatum(columnType % 90) : NULL_DATUM, columnType == 12 ? TimestreamColumnsResultSet.createDatum(Integer.MAX_VALUE) : NULL_DATUM, TimestreamColumnsResultSet.createDatum(i), TimestreamColumnsResultSet.createDatum("YES"), NULL_DATUM, NULL_DATUM, NULL_DATUM, NULL_DATUM, TimestreamColumnsResultSet.createDatum("NO"), TimestreamColumnsResultSet.createDatum("NO")}));
        }
        this.rowItr = columns.iterator();
    }
}

