/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQuery;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClient;
import com.amazonaws.services.timestreamquery.AmazonTimestreamQueryClientBuilder;
import com.amazonaws.services.timestreamquery.model.QueryRequest;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.Error;
import software.amazon.timestream.jdbc.TimestreamAzureADCredentialsProvider;
import software.amazon.timestream.jdbc.TimestreamConnectionProperty;
import software.amazon.timestream.jdbc.TimestreamDatabaseMetaData;
import software.amazon.timestream.jdbc.TimestreamDriver;
import software.amazon.timestream.jdbc.TimestreamOktaCredentialsProvider;
import software.amazon.timestream.jdbc.TimestreamPreparedStatement;
import software.amazon.timestream.jdbc.TimestreamStatement;
import software.amazon.timestream.jdbc.Warning;

public class TimestreamConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamConnection.class);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final TimestreamDatabaseMetaData databaseMetaData;
    private final Properties connectionProperties;
    private boolean metadataPreparedStatementEnabled = Boolean.parseBoolean(TimestreamConnectionProperty.ENABLE_METADATA_PREPARED_STATEMENT.getDefaultValue());
    private SQLWarning warnings;
    private Map<String, Class<?>> typeMap = new HashMap();
    @VisibleForTesting
    final ClientConfiguration clientConfiguration;
    AmazonTimestreamQuery queryClient;
    AmazonTimestreamQueryClientBuilder queryClientBuilder;

    TimestreamConnection(@NonNull Properties info, @NonNull ClientConfiguration clientConfiguration) throws SQLException {
        this(info, clientConfiguration, HttpClients.createDefault());
    }

    TimestreamConnection(@NonNull Properties info, @NonNull ClientConfiguration clientConfiguration, @NonNull CloseableHttpClient httpClient) throws SQLException {
        this.connectionProperties = info;
        this.clientConfiguration = clientConfiguration;
        this.initializeClients(info, httpClient);
        this.databaseMetaData = new TimestreamDatabaseMetaData(this);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.verifyOpen();
        this.warnings = null;
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            LOGGER.debug("Closing the current opened connection.");
            this.queryClient.shutdown();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.PARAMETERS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, Blob.class.toString());
    }

    @Override
    public Clob createClob() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, Clob.class.toString());
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, NClob.class.toString());
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_TYPE, SQLXML.class.toString());
    }

    @Override
    public TimestreamStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public TimestreamStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        this.checkStatementAttributes(resultSetType, resultSetConcurrency);
        return new TimestreamStatement(this);
    }

    @Override
    public TimestreamStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.PARAMETERS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.verifyOpen();
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Returning null for getCatalog() since there isn't a default catalog in use.");
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.verifyOpen();
        Properties clientInfo = new Properties();
        clientInfo.putAll((Map<?, ?>)this.connectionProperties);
        clientInfo.putIfAbsent(TimestreamConnectionProperty.APPLICATION_NAME.getConnectionProperty(), TimestreamDriver.APPLICATION_NAME);
        return clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.verifyOpen();
        if (name == null) {
            LOGGER.debug("Null value is passed as name, falling back to get client info with null.");
            return null;
        }
        this.connectionProperties.putIfAbsent(TimestreamConnectionProperty.APPLICATION_NAME.getConnectionProperty(), TimestreamDriver.APPLICATION_NAME);
        return this.connectionProperties.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.verifyOpen();
        return 2;
    }

    @Override
    public TimestreamDatabaseMetaData getMetaData() throws SQLException {
        this.verifyOpen();
        return this.databaseMetaData;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.verifyOpen();
        return this.queryClientBuilder.getClientConfiguration().getRequestTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        this.verifyOpen();
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.verifyOpen();
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.verifyOpen();
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.verifyOpen();
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.verifyOpen();
        return true;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, timeout);
        }
        AmazonTimestreamQuery client = (AmazonTimestreamQuery)((AmazonTimestreamQueryClientBuilder)this.getQueryClientBuilder().withClientConfiguration(new ClientConfiguration(this.queryClientBuilder.getClientConfiguration()).withConnectionTimeout(timeout * 1000))).build();
        try {
            client.query(new QueryRequest().withQueryString("SELECT 1"));
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Connection is no longer valid: {}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return null != iface && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.verifyOpen();
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_PREPARE_CALL, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.verifyOpen();
        return new TimestreamPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_GENERATED_KEYS, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.verifyOpen();
        this.checkStatementAttributes(resultSetType, resultSetConcurrency);
        return new TimestreamPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.PARAMETERS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_GENERATED_KEYS, new Object[0]);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_GENERATED_KEYS, new Object[0]);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void rollback() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Transactions are not supported, do nothing for setAutoCommit.");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Timestream does not support catalog. Do nothing.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.isClosed.get()) {
            HashMap<String, ClientInfoStatus> failures = new HashMap<String, ClientInfoStatus>();
            for (String name : properties.stringPropertyNames()) {
                failures.put(name, ClientInfoStatus.REASON_UNKNOWN);
            }
            throw Error.createSQLClientInfoException(LOGGER, Error.CONN_CLOSED, failures, new Object[0]);
        }
        if (properties == null) {
            properties = new Properties();
            this.addWarning(new SQLWarning(Warning.lookup(Warning.NULL_PROPERTY, new Object[0])));
        }
        this.connectionProperties.clear();
        for (String name : properties.stringPropertyNames()) {
            if (TimestreamConnectionProperty.isSupportedProperty(name)) {
                String value = properties.getProperty(name);
                this.connectionProperties.put(name, value);
                LOGGER.debug("Successfully set client info with name {{}} and value {{}}", (Object)name, (Object)value);
                continue;
            }
            this.addWarning(new SQLWarning(Warning.lookup(Warning.UNSUPPORTED_PROPERTY, name)));
        }
        LOGGER.debug("Successfully set client info with all properties.");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.isClosed.get()) {
            HashMap<String, ClientInfoStatus> failure = new HashMap<String, ClientInfoStatus>();
            failure.put(name, ClientInfoStatus.REASON_UNKNOWN);
            throw Error.createSQLClientInfoException(LOGGER, Error.CONN_CLOSED, failure, new Object[0]);
        }
        if (TimestreamConnectionProperty.isSupportedProperty(name)) {
            this.connectionProperties.put(name, value);
            LOGGER.debug("Successfully set client info with name {{}} and value {{}}", (Object)name, (Object)value);
        } else {
            this.addWarning(new SQLWarning(Warning.lookup(Warning.UNSUPPORTED_PROPERTY, name)));
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.verifyOpen();
        if (milliseconds < 0) {
            throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, milliseconds);
        }
        this.queryClientBuilder.getClientConfiguration().setRequestTimeout(milliseconds);
        LOGGER.debug("Network timeout is set to {} milliseconds.", (Object)milliseconds);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.verifyOpen();
        if (!readOnly) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.verifyOpen();
        throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.UNSUPPORTED_SCHEMA, new Object[0]);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.verifyOpen();
        if (level != 0) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.TRANSACTIONS_NOT_SUPPORTED, new Object[0]);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.verifyOpen();
        if (map == null) {
            LOGGER.debug("Null value is passed as conversion map, failing back to an empty hash map.");
            map = new HashMap();
        }
        this.typeMap = map;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw Error.createSQLException(LOGGER, Error.CANNOT_UNWRAP, iface.toString());
    }

    AmazonTimestreamQuery getQueryClient() {
        return this.queryClient;
    }

    boolean isMetadataPreparedStatementEnabled() {
        return this.metadataPreparedStatementEnabled;
    }

    AmazonTimestreamQueryClientBuilder getQueryClientBuilder() {
        AmazonTimestreamQueryClientBuilder client = (AmazonTimestreamQueryClientBuilder)((AmazonTimestreamQueryClientBuilder)AmazonTimestreamQueryClient.builder().withCredentials(this.queryClientBuilder.getCredentials())).withClientConfiguration(new ClientConfiguration(this.queryClientBuilder.getClientConfiguration()));
        String region = this.queryClientBuilder.getRegion();
        if (region != null) {
            client.setRegion(region);
        } else {
            client.setEndpointConfiguration(this.queryClientBuilder.getEndpoint());
        }
        return client;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    private void checkStatementAttributes(int resultSetType, int resultSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resultSetType != 1003) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.RESULT_FORWARD_ONLY, new Object[0]);
        }
        if (resultSetConcurrency != 1007) {
            throw Error.createSQLFeatureNotSupportedException(LOGGER, Error.READ_ONLY, new Object[0]);
        }
    }

    void buildQueryClientAndVerifyConnection(Properties info, AWSCredentialsProvider credentialsProvider) throws SQLException {
        this.queryClientBuilder = (AmazonTimestreamQueryClientBuilder)AmazonTimestreamQueryClient.builder().withClientConfiguration(this.clientConfiguration);
        Object endpoint = info.get(TimestreamConnectionProperty.ENDPOINT.getConnectionProperty());
        Object region = info.get(TimestreamConnectionProperty.REGION.getConnectionProperty());
        if (endpoint != null) {
            if (region == null) {
                throw Error.createSQLException(LOGGER, Error.MISSING_SERVICE_REGION, new Object[0]);
            }
            if (endpoint.toString().isEmpty()) {
                throw Error.createSQLException(LOGGER, Error.INVALID_ENDPOINT, new Object[0]);
            }
            this.queryClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint.toString(), region.toString()));
        } else {
            if (region == null) {
                region = TimestreamConnectionProperty.REGION.getDefaultValue();
            }
            this.queryClientBuilder.withRegion(region.toString());
        }
        this.queryClientBuilder.withCredentials(credentialsProvider);
        try {
            this.queryClient = (AmazonTimestreamQuery)this.queryClientBuilder.build();
            this.queryClient.query(new QueryRequest().withQueryString("SELECT 1"));
        }
        catch (Exception sdkClientException) {
            throw Error.createSQLException(LOGGER, "08006", sdkClientException, Error.CONN_FAILED, new Object[0]);
        }
    }

    private void configureSdkOptions(Properties info, ClientConfiguration clientConfiguration) throws SQLException {
        try {
            int requestTimeout = Integer.parseInt(info.getOrDefault((Object)TimestreamConnectionProperty.REQUEST_TIMEOUT.getConnectionProperty(), TimestreamConnectionProperty.REQUEST_TIMEOUT.getDefaultValue()).toString());
            int socketTimeout = Integer.parseInt(info.getOrDefault((Object)TimestreamConnectionProperty.SOCKET_TIMEOUT.getConnectionProperty(), TimestreamConnectionProperty.SOCKET_TIMEOUT.getDefaultValue()).toString());
            if (socketTimeout < 0) {
                throw Error.createSQLException(LOGGER, Error.INVALID_TIMEOUT, socketTimeout);
            }
            int maxConnections = Integer.parseInt(info.getOrDefault((Object)TimestreamConnectionProperty.MAX_CONNECTIONS.getConnectionProperty(), TimestreamConnectionProperty.MAX_CONNECTIONS.getDefaultValue()).toString());
            if (maxConnections < 0) {
                throw Error.createSQLException(LOGGER, Error.INVALID_MAX_CONNECTIONS, maxConnections);
            }
            String maxRetryCount = info.getOrDefault((Object)TimestreamConnectionProperty.MAX_RETRY_COUNT.getConnectionProperty(), TimestreamConnectionProperty.MAX_RETRY_COUNT.getDefaultValue()).toString();
            if (!maxRetryCount.isEmpty()) {
                int maxRetryCountClient = Integer.parseInt(maxRetryCount);
                if (maxRetryCountClient < 0) {
                    throw Error.createSQLException(LOGGER, Error.INVALID_MAX_RETRY_COUNT, maxRetryCountClient);
                }
                clientConfiguration.withMaxErrorRetry(maxRetryCountClient);
            }
            clientConfiguration.withRequestTimeout(requestTimeout).withSocketTimeout(socketTimeout).withMaxConnections(maxConnections);
        }
        catch (NumberFormatException ne) {
            throw Error.createSQLException(LOGGER, "08000", ne, Error.INVALID_NUMERIC_CONNECTION_VALUE, new Object[0]);
        }
    }

    TimestreamOktaCredentialsProvider createOktaCredentialsProvider(CloseableHttpClient httpClient, Map<String, String> oktaFieldsMap) {
        LOGGER.info("Creating an Okta credentials provider.");
        return new TimestreamOktaCredentialsProvider(httpClient, oktaFieldsMap);
    }

    TimestreamAzureADCredentialsProvider createAzureADCredentialsProvider(CloseableHttpClient httpClient, Map<String, String> azureADFieldsMap) {
        LOGGER.info("Creating an Azure AD credentials provider.");
        return new TimestreamAzureADCredentialsProvider(httpClient, azureADFieldsMap);
    }

    private void initializeClients(Properties info, CloseableHttpClient httpClient) throws SQLException {
        LOGGER.info("Initializing the client.");
        this.configureSdkOptions(info, this.clientConfiguration);
        this.buildQueryClientAndVerifyConnection(info, this.createCustomCredentialsProvider(info, httpClient));
        this.metadataPreparedStatementEnabled = Boolean.parseBoolean(info.getOrDefault((Object)TimestreamConnectionProperty.ENABLE_METADATA_PREPARED_STATEMENT.getConnectionProperty(), TimestreamConnectionProperty.ENABLE_METADATA_PREPARED_STATEMENT.getDefaultValue()).toString());
    }

    private void addWarning(SQLWarning warning) {
        LOGGER.warn(warning.getMessage());
        if (this.warnings == null) {
            this.warnings = warning;
            return;
        }
        this.warnings.setNextWarning(warning);
    }

    private void verifyOpen() throws SQLException {
        if (this.isClosed.get()) {
            throw Error.createSQLException(LOGGER, Error.CONN_CLOSED, new Object[0]);
        }
    }

    private AWSCredentialsProvider createCustomCredentialsProvider(Properties info, CloseableHttpClient httpClient) throws SQLException {
        String idpName = info.getOrDefault((Object)TimestreamConnectionProperty.IDP_NAME.getConnectionProperty(), "").toString();
        if (!idpName.isEmpty()) {
            switch (idpName.toLowerCase()) {
                case "okta": {
                    Map<String, String> oktaFieldsMap = this.extractRequiredProperties(info, TimestreamConnectionProperty.OKTA_PROPERTY_SET);
                    return this.createOktaCredentialsProvider(httpClient, oktaFieldsMap).createCredentialsProvider();
                }
                case "azuread": {
                    Map<String, String> azureADFieldsMap = this.extractRequiredProperties(info, TimestreamConnectionProperty.AAD_PROPERTY_SET);
                    return this.createAzureADCredentialsProvider(httpClient, azureADFieldsMap).createCredentialsProvider();
                }
            }
            throw Error.createSQLException(LOGGER, Error.UNSUPPORTED_SAML_CREDENTIALS_PROVIDER, idpName);
        }
        String awsCredentialsProviderClassName = info.getOrDefault((Object)TimestreamConnectionProperty.AWS_CREDENTIALS_PROVIDER_CLASS.getConnectionProperty(), "").toString();
        if (!awsCredentialsProviderClassName.isEmpty()) {
            switch (awsCredentialsProviderClassName.toLowerCase()) {
                case "propertiesfilecredentialsprovider": {
                    LOGGER.info("Creating a PropertiesFileCredentialsProvider.");
                    String customCredentialsFilePath = info.getOrDefault((Object)TimestreamConnectionProperty.CUSTOM_CREDENTIALS_FILE_PATH.getConnectionProperty(), "").toString();
                    if (customCredentialsFilePath.isEmpty()) {
                        throw Error.createSQLException(LOGGER, Error.INVALID_CREDENTIALS_FILE_PATH, new Object[0]);
                    }
                    return new PropertiesFileCredentialsProvider(customCredentialsFilePath);
                }
                case "instanceprofilecredentialsprovider": {
                    LOGGER.info("Creating an InstanceProfileCredentialsProvider.");
                    return new InstanceProfileCredentialsProvider(false);
                }
            }
            throw Error.createSQLException(LOGGER, Error.UNSUPPORTED_AWS_CREDENTIALS_PROVIDER, awsCredentialsProviderClassName);
        }
        String accessKey = info.getOrDefault((Object)TimestreamConnectionProperty.ACCESS_KEY_ID.getConnectionProperty(), "").toString();
        String secretKey = info.getOrDefault((Object)TimestreamConnectionProperty.SECRET_ACCESS_KEY.getConnectionProperty(), "").toString();
        if (!accessKey.isEmpty() && !secretKey.isEmpty()) {
            String sessionToken = info.getOrDefault((Object)TimestreamConnectionProperty.SESSION_TOKEN.getConnectionProperty(), "").toString();
            Object credentials = sessionToken.isEmpty() ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            LOGGER.info("Creating an AWSStaticCredentialsProvider.");
            return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        }
        LOGGER.info("No custom credentials provider is created. Returning the DefaultAWSCredentialsProviderChain.");
        return DefaultAWSCredentialsProviderChain.getInstance();
    }

    private Map<String, String> extractRequiredProperties(Properties info, EnumSet<TimestreamConnectionProperty> propertyNameList) throws SQLException {
        HashMap<String, String> requiredPropertiesMap = new HashMap<String, String>();
        for (TimestreamConnectionProperty property : propertyNameList) {
            String propertyName = property.getConnectionProperty();
            String value = info.getOrDefault((Object)propertyName, "").toString();
            if (!value.isEmpty()) {
                requiredPropertiesMap.put(propertyName, value);
                continue;
            }
            throw Error.createSQLException(LOGGER, Error.MISSING_REQUIRED_IDP_PARAMETER, propertyName);
        }
        return requiredPropertiesMap;
    }
}

