/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamDatabasesResultSet;
import software.amazon.timestream.jdbc.TimestreamStatement;

public class TimestreamSchemasResultSet
extends TimestreamBaseResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamDatabasesResultSet.class);
    private static final Datum NULL_DATUM = new Datum().withNullValue(Boolean.TRUE);
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_SCHEM"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_CATALOG"));
    private boolean isAfterLast = false;

    TimestreamSchemasResultSet(TimestreamConnection connection, String schemaPattern) throws SQLException {
        super(null, 20);
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.populateCurrentRows(connection, schemaPattern);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.isAfterLast;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Checking whether the last row of this TimestreamSchemasResultSet has been reached.");
        return !this.isAfterLast && !this.rowItr.hasNext();
    }

    @Override
    protected void doClose() {
        LOGGER.debug("Closed is called on this TimestreamSchemasResultSet, do nothing as the result set has already been closed.");
    }

    @Override
    protected boolean doNextPage() {
        LOGGER.debug("Attempting to retrieve the next page of results. There are no more pages, return false.");
        this.isAfterLast = true;
        return false;
    }

    private void populateCurrentRows(TimestreamConnection connection, String schemaPattern) throws SQLException {
        ArrayList<Row> databases = new ArrayList<Row>();
        try (TimestreamStatement statement = connection.createStatement();){
            LOGGER.debug("Retrieving a list of databases." + (Strings.isNullOrEmpty((String)schemaPattern) ? "" : " Schema pattern is " + schemaPattern + "."));
            String query = "SHOW DATABASES" + (Strings.isNullOrEmpty((String)schemaPattern) ? "" : " LIKE '" + schemaPattern + "'");
            try (ResultSet rs = statement.executeQuery(query);){
                while (rs != null && rs.next()) {
                    databases.add(new Row().withData(new Datum[]{new Datum().withScalarValue(rs.getString(1)), NULL_DATUM}));
                }
            }
        }
        LOGGER.debug("Retrieved {} databases.", (Object)databases.size());
        this.rowItr = databases.iterator();
    }
}

