/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.timestream.jdbc;

import com.amazonaws.services.timestreamquery.model.ColumnInfo;
import com.amazonaws.services.timestreamquery.model.Datum;
import com.amazonaws.services.timestreamquery.model.Row;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.timestream.jdbc.TimestreamBaseResultSet;
import software.amazon.timestream.jdbc.TimestreamConnection;
import software.amazon.timestream.jdbc.TimestreamDataType;
import software.amazon.timestream.jdbc.TimestreamSchemasResultSet;
import software.amazon.timestream.jdbc.TimestreamStatement;

public class TimestreamTablesResultSet
extends TimestreamBaseResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestreamTablesResultSet.class);
    private static final Datum NULL_DATUM = new Datum().withNullValue(Boolean.TRUE);
    private static final List<ColumnInfo> COLUMNS = ImmutableList.of((Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_CAT"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_SCHEM"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TABLE_TYPE"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "REMARKS"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TYPE_CAT"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TYPE_SCHEM"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "TYPE_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "SELF_REFERENCING_COL_NAME"), (Object)TimestreamDataType.createColumnInfo(TimestreamDataType.VARCHAR, "REF_GENERATION"));
    private final TimestreamConnection connection;
    private final String namePattern;
    private final Iterator<String> databaseItr;
    private boolean isAfterLast = false;

    TimestreamTablesResultSet(TimestreamConnection connection, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        super(null, 20);
        this.connection = connection;
        this.rsMeta = this.createColumnMetadata(COLUMNS);
        this.namePattern = tableNamePattern;
        if (null == types || 1 == types.length && "TABLE".equals(types[0])) {
            this.databaseItr = this.getDatabases(schemaPattern);
            this.doNextPage();
        } else {
            LOGGER.debug("No databases and tables available.");
            this.databaseItr = Collections.emptyIterator();
            this.rowItr = Collections.emptyIterator();
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.verifyOpen();
        return this.isAfterLast;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.verifyOpen();
        LOGGER.debug("Checking whether the last row of this TimestreamTablesResultSet has been reached.");
        return !this.isAfterLast && !this.databaseItr.hasNext() && !this.rowItr.hasNext();
    }

    @Override
    protected void doClose() {
        LOGGER.debug("Closed is called on this TimestreamTablesResultSet, do nothing as the result set has already been closed.");
    }

    @Override
    protected boolean doNextPage() throws SQLException {
        if (!this.databaseItr.hasNext()) {
            LOGGER.debug("No more databases to retrieve tables from.");
            this.isAfterLast = true;
            return false;
        }
        LOGGER.debug("Retrieve more tables from another database.");
        this.populateCurrentRows();
        return true;
    }

    private Iterator<String> getDatabases(String schemaPattern) throws SQLException {
        try (TimestreamSchemasResultSet rs = new TimestreamSchemasResultSet(this.connection, schemaPattern);){
            ArrayList<String> databases = new ArrayList<String>();
            while (rs.next()) {
                databases.add(rs.getString(1));
            }
            Iterator<String> iterator = databases.iterator();
            return iterator;
        }
    }

    private void populateCurrentRows() throws SQLException {
        ArrayList<Row> tables = new ArrayList<Row>();
        try (TimestreamStatement statement = this.connection.createStatement();){
            String database = this.databaseItr.next();
            String query = "SHOW TABLES FROM \"" + database + "\"" + (Strings.isNullOrEmpty((String)this.namePattern) ? "" : " LIKE '" + this.namePattern + "'");
            LOGGER.debug("Retrieving tables using query: \"{}\"", (Object)query);
            try (ResultSet rs = statement.executeQuery(query);){
                while (rs.next()) {
                    tables.add(new Row().withData(new Datum[]{NULL_DATUM, new Datum().withScalarValue(database), new Datum().withScalarValue(rs.getString(1)), new Datum().withScalarValue("TABLE"), NULL_DATUM, NULL_DATUM, NULL_DATUM, NULL_DATUM, NULL_DATUM, NULL_DATUM}));
                }
            }
        }
        this.rowItr = tables.iterator();
    }
}

