/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.values;

import us.springett.parsers.cpe.exceptions.CpeParsingException;

public enum Part {
    APPLICATION("a"),
    OPERATING_SYSTEM("o"),
    HARDWARE_DEVICE("h"),
    ANY("*"),
    NA("-");

    private final String abbreviation;

    private Part(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static Part getEnum(String part) throws CpeParsingException {
        for (Part p : Part.values()) {
            if (!p.getAbbreviation().equals(part)) continue;
            return p;
        }
        throw new CpeParsingException("Invalid Part Type: " + part);
    }
}

